/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final CategoryGeneral GENERAL = new CategoryGeneral();
    public static final CategoryGadgets GADGETS = new CategoryGadgets();
    public static final CategoryPasteContainers PASTE_CONTAINERS = new CategoryPasteContainers();
    public static final ForgeConfigSpec SERVER_CONFIG = SERVER_BUILDER.build();
    public static final ForgeConfigSpec CLIENT_CONFIG = CLIENT_BUILDER.build();

    public static final class CategoryPasteContainers {
        public final ForgeConfigSpec.IntValue capacityT1;
        public final ForgeConfigSpec.IntValue capacityT2;
        public final ForgeConfigSpec.IntValue capacityT3;

        private CategoryPasteContainers() {
            SERVER_BUILDER.comment("Configure the Paste Containers").push("Paste Containers");
            this.capacityT1 = CategoryPasteContainers.getMaxCapacity(1);
            this.capacityT2 = CategoryPasteContainers.getMaxCapacity(2);
            this.capacityT3 = CategoryPasteContainers.getMaxCapacity(3);
            SERVER_BUILDER.pop();
        }

        private static ForgeConfigSpec.IntValue getMaxCapacity(int tier) {
            return SERVER_BUILDER.comment(String.format("The maximum capacity of a tier %s (iron) Construction Paste Container", tier)).defineInRange(String.format("T%s Container Capacity", tier), (int)(512.0 * Math.pow(4.0, tier - 1)), 1, Integer.MAX_VALUE);
        }
    }

    public static final class CategoryGadgets {
        public final ForgeConfigSpec.IntValue maxRange;
        public final ForgeConfigSpec.IntValue placeSteps;
        public final GadgetConfig GADGET_BUILDING;
        public final GadgetConfig GADGET_EXCHANGER;
        public final CategoryGadgetDestruction GADGET_DESTRUCTION;
        public final CategoryGadgetCopyPaste GADGET_COPY_PASTE;

        private CategoryGadgets() {
            SERVER_BUILDER.comment("Configure the Gadgets").push("Gadgets");
            this.maxRange = SERVER_BUILDER.comment("The max range of the Gadgets").defineInRange("Maximum allowed Range", 15, 1, 32);
            this.placeSteps = SERVER_BUILDER.comment(new String[]{"Maximum amount of Blocks to be placed in one Tick.", "Notice that an EffectBlock takes 20 ticks to place, therefore a Server has to handle 20-times this value effect-block Tile's at once. Reduce this if  you notice lag-spikes from Players placing Templates.", "Of course decreasing this value will result in more time required to place large TemplateItem's."}).defineInRange("Max Placement/Tick", 1024, 1, Integer.MAX_VALUE);
            this.GADGET_BUILDING = new GadgetConfig("Building Gadget", 500000, 50, 10);
            this.GADGET_EXCHANGER = new GadgetConfig("Exchanging Gadget", 500000, 100, 10);
            this.GADGET_DESTRUCTION = new CategoryGadgetDestruction();
            this.GADGET_COPY_PASTE = new CategoryGadgetCopyPaste();
            SERVER_BUILDER.pop();
        }

        public static final class CategoryGadgetCopyPaste
        extends GadgetConfig {
            public final ForgeConfigSpec.IntValue copySteps;
            public final ForgeConfigSpec.IntValue maxCopySize;
            public final ForgeConfigSpec.IntValue maxBuildSize;

            private CategoryGadgetCopyPaste() {
                super("Copy-Paste Gadget", 500000, 50, 1);
                SERVER_BUILDER.comment("Energy Cost & Durability of the Copy-Paste Gadget").push("Copy-Paste Gadget");
                this.copySteps = SERVER_BUILDER.comment(new String[]{"Maximum amount of Blocks to be copied in one Tick. ", "Lower values may improve Server-Performance when copying large Templates"}).defineInRange("Max Copy/Tick", 32768, 1, Integer.MAX_VALUE);
                this.maxCopySize = SERVER_BUILDER.comment(new String[]{"Maximum dimensions (x, y and z) that can be copied by a Template without requiring special permission.", "Permission can be granted using the '/buildinggadgets OverrideCopySize [<Player>]' command."}).defineInRange("Max Copy Dimensions", 256, -1, Integer.MAX_VALUE);
                this.maxBuildSize = SERVER_BUILDER.comment(new String[]{"Maximum dimensions (x, y and z) that can be build by a Template without requiring special permission.", "Permission can be granted using the '/buildinggadgets OverrideBuildSize [<Player>]' command."}).defineInRange("Max Build Dimensions", 256, -1, Integer.MAX_VALUE);
                SERVER_BUILDER.pop();
            }
        }

        public static final class CategoryGadgetDestruction
        extends GadgetConfig {
            public final ForgeConfigSpec.IntValue destroySize;
            public final ForgeConfigSpec.DoubleValue nonFuzzyMultiplier;
            public final ForgeConfigSpec.BooleanValue nonFuzzyEnabled;

            private CategoryGadgetDestruction() {
                super("Destruction Gadget", 1000000, 200, 1);
                SERVER_BUILDER.comment("Energy Cost, Durability & Maximum Energy of the Destruction Gadget").push("Destruction Gadget");
                this.destroySize = SERVER_BUILDER.comment("The maximum dimensions, the Destruction Gadget can destroy.").defineInRange("Destroy Dimensions", 16, 0, 32);
                this.nonFuzzyMultiplier = SERVER_BUILDER.comment("The cost in energy/durability will increase by this amount when not in fuzzy mode").defineInRange("Non-Fuzzy Mode Multiplier", 2.0, 0.0, Double.MAX_VALUE);
                this.nonFuzzyEnabled = SERVER_BUILDER.comment("If enabled, the Destruction Gadget can be taken out of fuzzy mode, allowing only instances of the block clicked to be removed (at a higher cost)").define("Non-Fuzzy Mode Enabled", false);
                SERVER_BUILDER.pop();
            }
        }

        public static class GadgetConfig {
            public final ForgeConfigSpec.IntValue maxEnergy;
            public final ForgeConfigSpec.IntValue energyCost;
            public final ForgeConfigSpec.IntValue undoSize;

            public GadgetConfig(String name, int maxEnergy, int energyCost, int getMaxUndo) {
                SERVER_BUILDER.comment("Energy Cost & Durability of the " + name).push(name);
                this.maxEnergy = SERVER_BUILDER.comment("The max energy of the Gadget, set to 0 to disable energy usage").defineInRange("Maximum Energy", maxEnergy, 0, Integer.MAX_VALUE);
                this.energyCost = SERVER_BUILDER.comment("The Gadget's Energy cost per Operation").defineInRange("Energy Cost", energyCost, 0, Integer.MAX_VALUE);
                this.undoSize = SERVER_BUILDER.comment("The Gadget's Max Undo size (Note, the exchanger does not support undo)").defineInRange("Max Undo History Size", getMaxUndo, 0, 128);
                SERVER_BUILDER.pop();
            }
        }
    }

    public static final class CategoryGeneral {
        public final ForgeConfigSpec.DoubleValue rayTraceRange;
        public final ForgeConfigSpec.BooleanValue allowAbsoluteCoords;
        public final ForgeConfigSpec.BooleanValue absoluteCoordDefault;
        public final ForgeConfigSpec.BooleanValue allowOverwriteBlocks;

        private CategoryGeneral() {
            SERVER_BUILDER.comment("General mod settings").push("general");
            CLIENT_BUILDER.comment("General mod settings").push("general");
            this.allowAbsoluteCoords = SERVER_BUILDER.comment("Defined whether or not a player can use Absolute Coords mode in the Copy Paste Gadget").define("Allow Absolute Coords", true);
            this.rayTraceRange = SERVER_BUILDER.comment("Defines how far away you can build").defineInRange("MaxBuildDistance", 32.0, 1.0, 48.0);
            this.absoluteCoordDefault = CLIENT_BUILDER.comment(new String[]{"Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default.", "Set to true for Absolute, set to False for Relative."}).define("Default to absolute Coord-Mode", false);
            this.allowOverwriteBlocks = SERVER_BUILDER.comment(new String[]{"Whether the Building / CopyPaste Gadget can overwrite blocks like water, lava, grass, etc (like a player can).", "False will only allow it to overwrite air blocks."}).define("Allow non-Air-Block-Overwrite", true);
            CLIENT_BUILDER.pop();
            SERVER_BUILDER.pop();
        }
    }
}

