/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.direwolf20.buildinggadgets.common.world.MockTileEntityRenderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseRenderer {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final MockTileEntityRenderWorld tileEntityWorld = new MockTileEntityRenderWorld();
    private static final MockBuilderWorld builderWorld = new MockBuilderWorld();
    private static final Set<TileEntity> invalidTileEntities = new HashSet<TileEntity>();
    private static final RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        this.bindBlocks();
        if (this.isLinkable()) {
            BaseRenderer.renderLinkedInventoryOutline(evt, heldItem, player);
        }
    }

    private void bindBlocks() {
        BaseRenderer.getMc().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
    }

    private static void renderLinkedInventoryOutline(RenderWorldLastEvent evt, ItemStack item, PlayerEntity player) {
        Pair<BlockPos, RegistryKey<World>> dataFromStack = InventoryLinker.getDataFromStack(item);
        if (dataFromStack == null) {
            return;
        }
        if (!player.field_70170_p.func_234923_W_().equals(dataFromStack.getValue())) {
            return;
        }
        BlockPos pos = (BlockPos)dataFromStack.getKey();
        Vector3d renderPos = BaseRenderer.getMc().field_71460_t.func_215316_n().func_216785_c().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c((double)0.005f, (double)0.005f, (double)0.005f);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack stack = evt.getMatrixStack();
        stack.func_227860_a_();
        stack.func_227861_a_(-renderPos.func_82615_a(), -renderPos.func_82617_b(), -renderPos.func_82616_c());
        stack.func_227862_a_(1.01f, 1.01f, 1.01f);
        BaseRenderer.renderBoxSolid(stack.func_227866_c_().func_227870_a_(), buffer.getBuffer(OurRenderTypes.BlockOverlay), BlockPos.field_177992_a, 0.0f, 1.0f, 0.0f, 0.35f);
        stack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228461_a_();
    }

    int getEnergy(PlayerEntity player, ItemStack heldItem) {
        LazyOptional energy = heldItem.getCapability(CapabilityEnergy.ENERGY);
        if (player.func_184812_l_() || !energy.isPresent()) {
            return Integer.MAX_VALUE;
        }
        return energy.map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    protected static void renderMissingBlock(Matrix4f matrix, IVertexBuilder builder, BlockPos pos) {
        BaseRenderer.renderBoxSolid(matrix, builder, pos, 1.0f, 0.0f, 0.0f, 0.35f);
    }

    protected static void renderBoxSolid(Matrix4f matrix, IVertexBuilder builder, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.func_177958_n() - 0.001;
        double y = (double)pos.func_177956_o() - 0.001;
        double z = (double)pos.func_177952_p() - 0.001;
        double xEnd = (double)pos.func_177958_n() + 1.0015;
        double yEnd = (double)pos.func_177956_o() + 1.0015;
        double zEnd = (double)pos.func_177952_p() + 1.0015;
        BaseRenderer.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(Matrix4f matrix, IVertexBuilder builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public boolean isLinkable() {
        return false;
    }

    static Minecraft getMc() {
        return Minecraft.func_71410_x();
    }

    static MockBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }
}

