/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.network;

import com.mrh0.buildersaddition.network.IIntData;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateDataPacket {
    private BlockPos pos;
    private int data;

    public UpdateDataPacket(BlockPos pos, int data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(UpdateDataPacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.writeInt(packet.data);
    }

    public static UpdateDataPacket decode(PacketBuffer buf) {
        UpdateDataPacket scp = new UpdateDataPacket(buf.func_179259_c(), buf.readInt());
        return scp;
    }

    public static void handle(UpdateDataPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    UpdateDataPacket.sendUpdate(pkt.pos, player, pkt.data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(BlockPos pos, ServerPlayerEntity player, int data) {
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te != null && te instanceof IIntData) {
            ((IIntData)te).updateData(data);
            SUpdateTileEntityPacket supdatetileentitypacket = te.func_189518_D_();
            if (supdatetileentitypacket != null) {
                player.field_71135_a.func_147359_a((IPacket)supdatetileentitypacket);
            }
        }
    }
}

