/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.midi;

import com.mrh0.buildersaddition.midi.IMidiEvent;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

public class MidiHandler {
    public IMidiEvent midiEvent;
    private ArrayList<MidiDevice> devices;
    public static final int NOTE_ON = 144;
    public static final int NOTE_OFF = 128;
    public static final String[] NOTE_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    public MidiHandler(IMidiEvent midiEvent) {
        this.midiEvent = midiEvent;
        this.devices = new ArrayList();
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                System.out.println(infos[i]);
                List<Transmitter> transmitters = device.getTransmitters();
                for (int j = 0; j < transmitters.size(); ++j) {
                    transmitters.get(j).setReceiver(new MidiInputReceiver(device.getDeviceInfo().toString()));
                }
                Transmitter trans = device.getTransmitter();
                trans.setReceiver(new MidiInputReceiver(device.getDeviceInfo().toString()));
                device.open();
                this.devices.add(device);
                System.out.println(device.getDeviceInfo());
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }

    public boolean hasDevice() {
        return this.devices.size() > 0;
    }

    public void close() {
        for (MidiDevice d : this.devices) {
            d.close();
        }
    }

    public int playNote(String note, int octave) {
        int r = -1;
        if (octave == 1) {
            switch (note) {
                case "F#": {
                    r = -26;
                    break;
                }
                case "G": {
                    r = -25;
                    break;
                }
                case "G#": {
                    r = -24;
                    break;
                }
                case "A": {
                    r = -23;
                    break;
                }
                case "A#": {
                    r = -22;
                    break;
                }
                case "B": {
                    r = -21;
                }
            }
        }
        if (octave == 2) {
            switch (note) {
                case "C": {
                    r = -20;
                    break;
                }
                case "C#": {
                    r = -19;
                    break;
                }
                case "D": {
                    r = -18;
                    break;
                }
                case "D#": {
                    r = -15;
                    break;
                }
                case "E": {
                    r = -14;
                    break;
                }
                case "F": {
                    r = -13;
                    break;
                }
                case "F#": {
                    r = -12;
                    break;
                }
                case "G": {
                    r = -11;
                    break;
                }
                case "G#": {
                    r = -10;
                    break;
                }
                case "A": {
                    r = -9;
                    break;
                }
                case "A#": {
                    r = -8;
                    break;
                }
                case "B": {
                    r = -7;
                }
            }
        }
        if (octave == 3) {
            switch (note) {
                case "C": {
                    r = -6;
                    break;
                }
                case "C#": {
                    r = -5;
                    break;
                }
                case "D": {
                    r = -4;
                    break;
                }
                case "D#": {
                    r = -3;
                    break;
                }
                case "E": {
                    r = -2;
                    break;
                }
                case "F": {
                    r = -1;
                    break;
                }
                case "F#": {
                    r = 0;
                    break;
                }
                case "G": {
                    r = 1;
                    break;
                }
                case "G#": {
                    r = 2;
                    break;
                }
                case "A": {
                    r = 3;
                    break;
                }
                case "A#": {
                    r = 4;
                    break;
                }
                case "B": {
                    r = 5;
                }
            }
        }
        if (octave == 4) {
            switch (note) {
                case "C": {
                    r = 6;
                    break;
                }
                case "C#": {
                    r = 7;
                    break;
                }
                case "D": {
                    r = 8;
                    break;
                }
                case "D#": {
                    r = 9;
                    break;
                }
                case "E": {
                    r = 10;
                    break;
                }
                case "F": {
                    r = 11;
                    break;
                }
                case "F#": {
                    r = 12;
                    break;
                }
                case "G": {
                    r = 13;
                    break;
                }
                case "G#": {
                    r = 14;
                    break;
                }
                case "A": {
                    r = 15;
                    break;
                }
                case "A#": {
                    r = 16;
                    break;
                }
                case "B": {
                    r = 17;
                }
            }
        }
        if (octave == 5) {
            switch (note) {
                case "C": {
                    r = 18;
                    break;
                }
                case "C#": {
                    r = 19;
                    break;
                }
                case "D": {
                    r = 20;
                    break;
                }
                case "D#": {
                    r = 21;
                    break;
                }
                case "E": {
                    r = 22;
                    break;
                }
                case "F": {
                    r = 23;
                    break;
                }
                case "F#": {
                    r = 24;
                    break;
                }
                case "G": {
                    r = 25;
                    break;
                }
                case "G#": {
                    r = 26;
                    break;
                }
                case "A": {
                    r = 27;
                    break;
                }
                case "A#": {
                    r = 28;
                    break;
                }
                case "B": {
                    r = 29;
                }
            }
        }
        if (octave == 6) {
            switch (note) {
                case "C": {
                    r = 42;
                    break;
                }
                case "C#": {
                    r = 43;
                    break;
                }
                case "D": {
                    r = 44;
                    break;
                }
                case "D#": {
                    r = 45;
                    break;
                }
                case "E": {
                    r = 46;
                    break;
                }
                case "F": {
                    r = 47;
                    break;
                }
                case "F#": {
                    r = 48;
                    break;
                }
                case "G": {
                    r = 49;
                }
            }
        }
        return r;
    }

    public class MidiInputReceiver
    implements Receiver {
        public String name;

        public MidiInputReceiver(String name) {
            this.name = name;
        }

        @Override
        public void send(MidiMessage msg, long timeStamp) {
            if (msg instanceof ShortMessage) {
                ShortMessage sm = (ShortMessage)msg;
                if (sm.getCommand() == 144) {
                    int key = sm.getData1();
                    int octave = key / 12 - 1;
                    int note = key % 12;
                    String noteName = NOTE_NAMES[note];
                    int velocity = sm.getData2();
                    int mcnote = MidiHandler.this.playNote(noteName, octave);
                    if (MidiHandler.this.midiEvent != null) {
                        MidiHandler.this.midiEvent.minecraftNote(mcnote, velocity > 0);
                    }
                } else if (sm.getCommand() == 128) {
                    int key = sm.getData1();
                    int octave = key / 12 - 1;
                    int note = key % 12;
                    String noteName = NOTE_NAMES[note];
                    int n = sm.getData2();
                }
            } else {
                System.out.println("Midi Controller: " + msg.getClass());
            }
        }

        @Override
        public void close() {
        }
    }
}

