/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.items.GummyCardItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class EnderlingOfferMaker {
    public static MerchantOffer createCardBuyOffer() {
        ItemStack card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        ItemStack zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), EnderlingOfferMaker.getZylexValueOfCard(card));
        if (Math.random() < 0.3) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("foil", true);
            card.func_77982_d(nbt);
        }
        return new MerchantOffer(card, zylex, 1, 2, 1.0f);
    }

    public static MerchantOffer createBulkCardBuyOffer() {
        ItemStack card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard(), 8);
        ItemStack zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), EnderlingOfferMaker.getZylexValueOfCard(card) * 6);
        return new MerchantOffer(card, zylex, 1, 6, 1.0f);
    }

    public static MerchantOffer createGradedCardBuyOffer() {
        ItemStack card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        CompoundNBT nbt = new CompoundNBT();
        int i = (int)(Math.random() * 200.0) + 1;
        int grade = i < 20 ? 1 : (i < 80 ? 2 : (i < 140 ? 3 : 4));
        if (Math.random() < 0.3) {
            nbt.func_74757_a("foil", true);
        }
        nbt.func_74768_a("grade", grade);
        card.func_77982_d(nbt);
        int val = EnderlingOfferMaker.getZylexValueOfCard(card);
        ItemStack zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), val);
        if (val > 64) {
            zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_BLOCK_ITEM.get(), (int)((double)(val / 9) + 0.5));
        }
        return new MerchantOffer(card, zylex, 3, grade * 2, 1.0f);
    }

    public static MerchantOffer createGradedCardSellOffer() {
        ItemStack card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        CompoundNBT nbt = new CompoundNBT();
        int i = (int)(Math.random() * 200.0) + 1;
        int grade = i < 50 ? 1 : (i < 105 ? 2 : (i < 160 ? 3 : (i < 200 ? 4 : 5)));
        if (Math.random() < 0.3) {
            nbt.func_74757_a("foil", true);
        }
        nbt.func_74768_a("grade", grade);
        card.func_77982_d(nbt);
        int val = EnderlingOfferMaker.getZylexValueOfCard(card);
        ItemStack zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), val);
        if (val > 64) {
            zylex = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_BLOCK_ITEM.get(), (int)((double)(val / 9) + 0.5));
        }
        return new MerchantOffer(zylex, card, 1, grade, 1.0f);
    }

    public static MerchantOffer createCardTradeOffer() {
        ItemStack card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        ItemStack card2 = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        CompoundNBT nbt = new CompoundNBT();
        while (Math.abs(EnderlingOfferMaker.getZylexValueOfCard(card) - EnderlingOfferMaker.getZylexValueOfCard(card2)) > 2) {
            card = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
            card2 = new ItemStack((IItemProvider)EnderlingOfferMaker.getRandomLoadedCard());
        }
        int i = (int)(Math.random() * 200.0) + 1;
        int grade = i < 100 ? 0 : (i < 125 ? 1 : (i < 150 ? 2 : (i < 175 ? 3 : (i < 200 ? 4 : 5))));
        if (Math.random() < 0.3) {
            nbt.func_74757_a("foil", true);
        }
        if (grade > 0) {
            nbt.func_74768_a("grade", grade);
        }
        card.func_77982_d(nbt);
        card2.func_77982_d(nbt);
        return new MerchantOffer(card, card2, 1, grade * 2, 1.0f);
    }

    public static MerchantOffer createPackOffer() {
        if (Math.random() > 0.5) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), 6 + (int)(Math.random() * 3.0)), new ItemStack((IItemProvider)BuddycardsItems.END_SET.PACK.get()), 1, 5, 1.0f);
        }
        return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), 13 + (int)(Math.random() * 4.0)), new ItemStack((IItemProvider)BuddycardsItems.MYSTERY_PACK.get()), 1, 8, 1.0f);
    }

    public static MerchantOffer createGenericOffer() {
        int amount = (int)(Math.random() * 12.0) + 1;
        double random = Math.random();
        if (random > 0.92) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), amount + 1 + (int)(Math.random() / 2.0 * (double)amount)), new ItemStack((IItemProvider)BuddycardsItems.CARD_STAND_ITEM.get(), amount / 3 + 1), 3, amount, 1.0f);
        }
        if (random > 0.86) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), amount + (int)(Math.random() / 2.0 * (double)amount)), new ItemStack((IItemProvider)BuddycardsItems.GRADING_SLEEVE.get(), amount / 3 + 1), 3, amount, 1.0f);
        }
        if (random > 0.8) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), amount + (int)(Math.random() * 2.0 * (double)amount)), new ItemStack((IItemProvider)BuddycardsItems.BUDDYSTEEL_NUGGET.get(), amount), 3, amount * 2, 1.0f);
        }
        if (random > 0.75) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX.get(), 6 + (int)(Math.random() * 4.0)), new ItemStack((IItemProvider)BuddycardsItems.ENDER_BINDER.get()), 1, 6, 1.0f);
        }
        if (random > 0.3) {
            return EnderlingOfferMaker.createBulkCardBuyOffer();
        }
        return EnderlingOfferMaker.createCardTradeOffer();
    }

    public static MerchantOffer createSpecialtyOffer(Random random) {
        double rand = Math.random() * 2.0;
        if (rand % 1.0 > 0.92) {
            ItemStack medal = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_MEDAL.get());
            if ((int)rand != 0) {
                EnchantmentHelper.func_77504_a((Random)random, (ItemStack)medal, (int)15, (boolean)true);
            }
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_TOKEN.get(), 2 + (int)(rand * 2.0)), medal, 1, 32, 1.0f);
        }
        if (rand % 1.0 > 0.8) {
            ItemStack boots = new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_BOOTS.get());
            if ((int)rand != 0) {
                EnchantmentHelper.func_77504_a((Random)random, (ItemStack)boots, (int)15, (boolean)true);
            }
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_TOKEN.get(), 2 + (int)rand), boots, 1, 32, 1.0f);
        }
        if (rand % 1.0 > 0.4) {
            return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_TOKEN.get(), 2 + (int)rand), new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_RING.get()), 1, 32, 1.0f);
        }
        return new MerchantOffer(new ItemStack((IItemProvider)BuddycardsItems.ZYLEX_TOKEN.get(), 2 + (int)rand), new ItemStack((IItemProvider)BuddycardsItems.MYSTERY_PACK.get()), 2 + (int)(rand * 2.0), 32, 1.0f);
    }

    private static int getZylexValueOfCard(ItemStack card) {
        double value = 0.5;
        switch (card.func_77953_t()) {
            case EPIC: {
                value += 3.0;
            }
            case RARE: {
                value += 1.0;
            }
            case UNCOMMON: {
                value += 0.5;
            }
        }
        if (card.func_77962_s()) {
            value *= 2.1;
        }
        if (card.func_77978_p() != null && card.func_77978_p().func_74764_b("grade")) {
            switch (card.func_77978_p().func_74762_e("grade")) {
                case 1: {
                    value *= 0.75;
                    break;
                }
                case 2: {
                    value *= 1.6;
                    break;
                }
                case 3: {
                    value *= 2.3;
                    break;
                }
                case 4: {
                    value *= 5.1;
                    break;
                }
                case 5: {
                    value *= 28.8;
                }
            }
        }
        int fval = (int)value;
        return Math.max(fval, 1);
    }

    public static CardItem getRandomLoadedCard() {
        CardItem card = (CardItem)BuddycardsItems.LOADED_CARDS.get((int)(Math.random() * (double)BuddycardsItems.LOADED_CARDS.size())).get();
        while (card instanceof GummyCardItem || card.getRegistryName().toString().endsWith("s")) {
            card = (CardItem)BuddycardsItems.LOADED_CARDS.get((int)(Math.random() * (double)BuddycardsItems.LOADED_CARDS.size())).get();
        }
        return card;
    }
}

