/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.integration.aquaculture.BuddysteelFishingRodItem;
import com.wildcard.buddycards.integration.fd.BuddysteelFoodKnifeItem;
import com.wildcard.buddycards.items.BinderItem;
import com.wildcard.buddycards.items.MedalItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelArmorItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelAxeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelHoeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelPickaxeItem;
import com.wildcard.buddycards.items.buddysteel.BuddysteelShovelItem;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EnchantmentHandler {
    private Map<String, NonNullList<ItemStack>> items = new HashMap<String, NonNullList<ItemStack>>();
    public static final EnchantmentType BUDDY_BINDABLE = EnchantmentType.create((String)"BUDDY_BINDABLE", EnchantmentHandler::canBuddyBind);
    public static final EnchantmentType BUDDY_MEDAL = EnchantmentType.create((String)"BUDDY_MEDAL", i -> i instanceof MedalItem);
    public static final EnchantmentType BUDDY_BINDER = EnchantmentType.create((String)"BUDDY_BINDER", i -> i instanceof BinderItem);

    @SubscribeEvent
    public void drop(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            boolean empty = true;
            NonNullList itemsToSave = NonNullList.func_191196_a();
            for (ItemEntity i : event.getDrops()) {
                switch (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)BuddycardsMisc.BUDDY_BINDING.get()), (ItemStack)i.func_92059_d())) {
                    case 1: {
                        if (Math.random() < 0.3) break;
                    }
                    case 2: {
                        if (Math.random() < 0.2) break;
                    }
                    case 3: {
                        itemsToSave.add((Object)i.func_92059_d());
                        empty = false;
                    }
                }
            }
            if (!empty) {
                this.items.put(player.func_110124_au().toString(), (NonNullList<ItemStack>)itemsToSave);
            }
            if (this.items.containsKey(player.func_110124_au().toString())) {
                List list = this.items.get(player.func_110124_au().toString()).subList(0, this.items.get(player.func_110124_au().toString()).size());
                Stream stream = StreamSupport.stream(event.getDrops().spliterator(), false);
                Set remove = stream.filter(itemToFilter -> list.contains(itemToFilter.func_92059_d())).collect(Collectors.toSet());
                event.getDrops().removeAll(remove);
            }
        }
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        if (event.isWasDeath() && this.items.containsKey(player.func_110124_au().toString())) {
            for (ItemStack i : this.items.get(player.func_110124_au().toString())) {
                player.func_191521_c(i);
            }
            this.items.remove(player.func_110124_au().toString());
        }
    }

    public static boolean canBuddyBind(Item item) {
        if (item instanceof BinderItem || item instanceof MedalItem || item instanceof BuddysteelArmorItem || item instanceof BuddysteelAxeItem || item instanceof BuddysteelHoeItem || item instanceof BuddysteelPickaxeItem || item instanceof BuddysteelShovelItem || item instanceof BuddysteelPickaxeItem) {
            return true;
        }
        if (ModList.get().isLoaded("aquaculture") && item instanceof BuddysteelFishingRodItem) {
            return true;
        }
        if (ModList.get().isLoaded("farmersdelight") && item instanceof BuddysteelFoodKnifeItem) {
            return true;
        }
        return item.equals(BuddycardsItems.ZYLEX_RING.get()) || item.equals(BuddycardsItems.LUMINIS_RING.get());
    }
}

