/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks;

import com.wildcard.buddycards.blocks.tiles.BuddysteelVaultTile;
import com.wildcard.buddycards.registries.BuddycardsItems;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class BuddysteelVaultBlock
extends ContainerBlock {
    public static final DirectionProperty DIR = HorizontalBlock.field_185512_D;
    protected static final VoxelShape VAULT_SHAPE = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    final int SET_NUMBER;
    final String SPECIFIC_MOD;

    public BuddysteelVaultBlock(int setNumber, String modId) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S).func_200948_a(5.0f, 1200.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIR, (Comparable)Direction.NORTH));
        this.SET_NUMBER = setNumber;
        this.SPECIFIC_MOD = modId;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VAULT_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DIR, (Comparable)context.func_195992_f());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BuddysteelVaultTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIR});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BuddysteelVaultTile) {
            tileentity.func_145829_t();
            if (stack.func_82837_s()) {
                ((BuddysteelVaultTile)tileentity).setDisplayName(stack.func_200301_q());
            }
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (playerIn instanceof ServerPlayerEntity && tileentity instanceof BuddysteelVaultTile) {
            if (playerIn.func_184586_b(handIn).func_77973_b() == BuddycardsItems.BUDDYSTEEL_KEY.get()) {
                if (((BuddysteelVaultTile)tileentity).isLocked()) {
                    if (((BuddysteelVaultTile)tileentity).toggleLock(playerIn.func_110124_au())) {
                        playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.vault.unlock"), true);
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.vault.fail_unlock"), true);
                    }
                } else {
                    ((BuddysteelVaultTile)tileentity).toggleLock(playerIn.func_110124_au());
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("block.buddycards.vault.lock"), true);
                }
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((BuddysteelVaultTile)tileentity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BuddysteelVaultTile();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (world.func_175625_s(pos) instanceof BuddysteelVaultTile && !player.func_184812_l_()) {
            if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == BuddycardsItems.ZYLEX_RING.get() || ModList.get().isLoaded("curios") && CuriosApi.getCuriosHelper().findEquippedCurio((Item)BuddycardsItems.ZYLEX_RING.get(), (LivingEntity)player).isPresent() && ((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)BuddycardsItems.ZYLEX_RING.get()), (LivingEntity)player).get()).right).func_77973_b().equals(BuddycardsItems.ZYLEX_RING.get())) {
                ItemStack i = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("BlockEntityTag", (INBT)world.func_175625_s(pos).func_189515_b(new CompoundNBT()));
                i.func_77982_d(nbt);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)i);
            } else {
                IItemHandler handler = (IItemHandler)world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)new ItemStackHandler());
                for (int i = 0; i < handler.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                }
                if (!player.func_184812_l_()) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()));
                }
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!ModList.get().isLoaded(this.SPECIFIC_MOD)) {
            return;
        }
        super.func_149666_a(group, items);
    }
}

