/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.google.common.collect.Lists;
import com.wildcard.buddycards.blocks.CardDisplayBlock;
import com.wildcard.buddycards.blocks.CardStandBlock;
import com.wildcard.buddycards.blocks.tiles.CardDisplayTile;
import com.wildcard.buddycards.blocks.tiles.CardStandTile;
import com.wildcard.buddycards.registries.BuddycardsBlocks;
import com.wildcard.buddycards.registries.BuddycardsItems;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockExplodeHandler {
    @SubscribeEvent
    public void explosionModify(ExplosionEvent.Detonate event) {
        ArrayList replacedExplosion = Lists.newArrayList();
        int deepLuminisBlocks = 0;
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            TileEntity tile;
            BlockState targetBlock = event.getWorld().func_180495_p((BlockPos)event.getAffectedBlocks().get(i));
            if (targetBlock.func_177230_c() instanceof CardDisplayBlock) {
                tile = (CardDisplayTile)event.getWorld().func_175625_s((BlockPos)event.getAffectedBlocks().get(i));
                if (tile.isLocked()) continue;
                replacedExplosion.add(event.getAffectedBlocks().get(i));
                continue;
            }
            if (targetBlock.func_177230_c() instanceof CardStandBlock) {
                tile = (CardStandTile)event.getWorld().func_175625_s((BlockPos)event.getAffectedBlocks().get(i));
                if (tile.isLocked()) continue;
                replacedExplosion.add(event.getAffectedBlocks().get(i));
                continue;
            }
            if (targetBlock.func_177230_c().equals(BuddycardsBlocks.DEEP_LUMINIS_BLOCK.get())) {
                ++deepLuminisBlocks;
                replacedExplosion.add(event.getAffectedBlocks().get(i));
                continue;
            }
            replacedExplosion.add(event.getAffectedBlocks().get(i));
        }
        event.getExplosion().func_180342_d();
        event.getAffectedBlocks().addAll(replacedExplosion);
        if (Math.random() * 2.0 < (double)deepLuminisBlocks) {
            InventoryHelper.func_180173_a((World)event.getWorld(), (double)event.getExplosion().getPosition().field_72450_a, (double)event.getExplosion().getPosition().field_72448_b, (double)event.getExplosion().getPosition().field_72449_c, (ItemStack)BlockExplodeHandler.createLuminisDrop(event.getWorld().func_201674_k(), deepLuminisBlocks));
        }
    }

    public static ItemStack createLuminisDrop(Random random, int luminisIn) {
        double rand = Math.random() * 2.0;
        if (rand % 1.0 > 0.92) {
            ItemStack medal = new ItemStack((IItemProvider)BuddycardsItems.LUMINIS_MEDAL.get());
            if ((int)rand != 0) {
                EnchantmentHelper.func_77504_a((Random)random, (ItemStack)medal, (int)(10 * luminisIn), (boolean)true);
            }
            return medal;
        }
        if (rand % 1.0 > 0.8) {
            ItemStack pick = new ItemStack((IItemProvider)BuddycardsItems.LUMINIS_PICKAXE.get());
            if ((int)rand != 0) {
                EnchantmentHelper.func_77504_a((Random)random, (ItemStack)pick, (int)(10 * luminisIn), (boolean)true);
            }
            return pick;
        }
        if (rand % 1.0 > 0.4) {
            return new ItemStack((IItemProvider)BuddycardsItems.LUMINIS_RING.get(), 1);
        }
        return new ItemStack((IItemProvider)BuddycardsItems.LUMINIS.get(), (int)(rand * 32.0));
    }
}

