/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.storage.WorldSavedData;

public class WorldEntitySaveData
extends WorldSavedData {
    public static final String ID = "brandonscore_world_entity";
    private List<WorldEntity> entities = new ArrayList<WorldEntity>();
    private Runnable saveCallback;

    public WorldEntitySaveData(String name) {
        super(name);
    }

    public WorldEntitySaveData() {
        super(ID);
    }

    public void updateEntities(List<WorldEntity> entities) {
        this.entities.clear();
        if (entities != null) {
            this.entities.addAll(entities);
        }
    }

    public void setSaveCallback(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public List<WorldEntity> getEntities() {
        return this.entities;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("entities", 10);
        for (INBT inbt : list) {
            this.entities.add(WorldEntity.readWorldEntity((CompoundNBT)inbt));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (WorldEntity entity : this.entities) {
            CompoundNBT entityTag = new CompoundNBT();
            entity.write(entityTag);
            list.add((Object)entityTag);
        }
        compound.func_218657_a("entities", (INBT)list);
        return compound;
    }

    public void func_215158_a(File fileIn) {
        this.func_76186_a(true);
        this.saveCallback.run();
        super.func_215158_a(fileIn);
    }
}

