/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.nbt.CompoundNBT;

public class FilterTamed
extends FilterBase {
    protected boolean whitelistTamed = true;
    protected boolean includeTamable = true;

    public FilterTamed(EntityFilter filter) {
        super(filter);
    }

    public void setIncludeTamable(boolean includeTamable) {
        boolean prev = this.includeTamable;
        this.includeTamable = includeTamable;
        this.getFilter().nodeModified(this);
        this.includeTamable = prev;
    }

    public void setWhitelistTamed(boolean whitelistTamed) {
        boolean prev = this.whitelistTamed;
        this.whitelistTamed = whitelistTamed;
        this.getFilter().nodeModified(this);
        this.whitelistTamed = prev;
    }

    public boolean isIncludeTamable() {
        return this.includeTamable;
    }

    public boolean isWhitelistTamed() {
        return this.whitelistTamed;
    }

    @Override
    public boolean test(Entity entity) {
        boolean isTamable = entity instanceof TameableEntity;
        if (isTamable) {
            TameableEntity ownable = (TameableEntity)entity;
            if (ownable.func_184753_b() != null) {
                return this.whitelistTamed;
            }
            return this.includeTamable;
        }
        return !this.whitelistTamed;
    }

    @Override
    public FilterType getType() {
        return FilterType.TAMED;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("include", this.whitelistTamed);
        compound.func_74757_a("tamable", this.includeTamable);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.whitelistTamed = nbt.func_74767_n("include");
        this.includeTamable = nbt.func_74767_n("tamable");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistTamed);
        output.writeBoolean(this.includeTamable);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistTamed = input.readBoolean();
        this.includeTamable = input.readBoolean();
    }
}

