/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;

public class FilterAdults
extends FilterBase {
    protected boolean whitelistAdults = true;
    protected boolean includeNonAgeable = true;

    public FilterAdults(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistAdults(boolean whitelistAdults) {
        boolean prev = this.whitelistAdults;
        this.whitelistAdults = whitelistAdults;
        this.getFilter().nodeModified(this);
        this.whitelistAdults = prev;
    }

    public void setIncludeNonAgeable(boolean includeNonAgeable) {
        boolean prev = this.includeNonAgeable;
        this.includeNonAgeable = includeNonAgeable;
        this.getFilter().nodeModified(this);
        this.includeNonAgeable = prev;
    }

    public boolean isWhitelistAdults() {
        return this.whitelistAdults;
    }

    public boolean isIncludeNonAgeable() {
        return this.includeNonAgeable;
    }

    @Override
    public boolean test(Entity entity) {
        boolean isAgeable = entity instanceof AgeableEntity;
        if (isAgeable) {
            AgeableEntity ageable = (AgeableEntity)entity;
            return this.whitelistAdults == !ageable.func_70631_g_();
        }
        return this.includeNonAgeable;
    }

    @Override
    public FilterType getType() {
        return FilterType.ADULTS;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("include", this.whitelistAdults);
        compound.func_74757_a("tamable", this.includeNonAgeable);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.whitelistAdults = nbt.func_74767_n("include");
        this.includeNonAgeable = nbt.func_74767_n("tamable");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistAdults);
        output.writeBoolean(this.includeNonAgeable);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistAdults = input.readBoolean();
        this.includeNonAgeable = input.readBoolean();
    }
}

