/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3i;

public class ManagedVector3i
extends AbstractManagedData<Vector3i> {
    private Vector3i value;
    private Vector3i defaultValue;
    protected Function<Vector3i, Vector3i> validator = null;

    public ManagedVector3i(String name, @Nullable Vector3i defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : new Vector3i(defaultValue.func_177958_n(), defaultValue.func_177956_o(), defaultValue.func_177952_p());
    }

    public ManagedVector3i(String name, DataFlags ... flags) {
        this(name, new Vector3i(0, 0, 0), flags);
    }

    public Vector3i set(Vector3i value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Vector3i prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Vector3i get() {
        return this.value;
    }

    public ManagedVector3i setValidator(Function<Vector3i, Vector3i> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeVec3i(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readVec3i() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        if (this.value == null) {
            nbt.func_74757_a("null", true);
        } else {
            nbt.func_74768_a("x", this.value.func_177958_n());
            nbt.func_74768_a("y", this.value.func_177956_o());
            nbt.func_74768_a("z", this.value.func_177952_p());
        }
        compound.func_218657_a(this.name, (INBT)nbt);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        CompoundNBT nbt;
        this.value = !compound.func_150297_b(this.name, 10) ? (this.defaultValue == null ? null : new Vector3i(this.defaultValue.func_177958_n(), this.defaultValue.func_177956_o(), this.defaultValue.func_177952_p())) : ((nbt = compound.func_74775_l(this.name)).func_74764_b("null") ? null : new Vector3i(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

