/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.lib.ThreadedImageDownloader;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public class DLRSCache {
    public static final DLResourceLocation DOWNLOADING_TEXTURE = new DLResourceLocation("brandonscore".toLowerCase(Locale.ENGLISH), "textures/loading_texture.png");
    private static Map<String, DLResourceLocation> resourceCache;
    private static File cacheFolder;
    private static Pattern urlStripper;

    public static void initialize() {
        cacheFolder = new File(FileHandler.brandon3055Folder, "ResourceCache");
        cacheFolder.mkdirs();
    }

    public static DLResourceLocation getResource(String url) {
        String key = urlStripper.matcher(url).replaceAll("_").toLowerCase(Locale.ENGLISH);
        if (!resourceCache.containsKey(key)) {
            DLResourceLocation resourceLocation = new DLResourceLocation("brandonscore".toLowerCase(Locale.ENGLISH), key);
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            File cache = new File(cacheFolder, "Cache#" + url.hashCode() + ".png");
            ThreadedImageDownloader downloader = new ThreadedImageDownloader(cache, url, DOWNLOADING_TEXTURE);
            downloader.setDlLocation(resourceLocation);
            texturemanager.func_229263_a_((ResourceLocation)resourceLocation, (Texture)downloader);
            resourceCache.put(key, resourceLocation);
        }
        return resourceCache.get(key);
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static void clearFileCache() {
        DLRSCache.clearResourceCache();
        File[] files = cacheFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("Cache#")) continue;
                file.delete();
            }
        }
    }

    public static void clearResourceCache(String url) {
        String key = urlStripper.matcher(url).replaceAll("_").toLowerCase(Locale.ENGLISH);
        resourceCache.remove(key);
    }

    public static void clearFileCache(String url) {
        DLRSCache.clearResourceCache(url);
        File[] files = cacheFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals("Cache#" + url.hashCode() + ".png")) continue;
                file.delete();
                return;
            }
        }
    }

    static {
        DLRSCache.DOWNLOADING_TEXTURE.height = 16;
        DLRSCache.DOWNLOADING_TEXTURE.width = 16;
        DLRSCache.DOWNLOADING_TEXTURE.sizeSet = true;
        resourceCache = new HashMap<String, DLResourceLocation>();
        urlStripper = Pattern.compile("([^a-zA-Z0-9]*)");
    }
}

