/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.items;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.OPMultiProvider;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

@Deprecated
public class ItemEnergyBase
extends ItemBCore {
    private long capacity;
    private long receive;
    private long extract;

    public ItemEnergyBase(Item.Properties properties) {
        super(properties);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            this.setEnergy(stack, this.getCapacity(stack));
            items.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void setEnergyStats(long capacity, long receive, long extract) {
        this.capacity = capacity;
        this.receive = receive;
        this.extract = extract;
    }

    protected long getCapacity(ItemStack stack) {
        return this.capacity;
    }

    protected long getMaxReceive(ItemStack stack) {
        return this.receive;
    }

    protected long getMaxExtract(ItemStack stack) {
        return this.extract;
    }

    protected long receiveEnergy(ItemStack stack, long maxReceive, boolean simulate) {
        if (this.getMaxReceive(stack) > 0L) {
            long energy = ItemNBTHelper.getLong(stack, "energy", 0L);
            long energyReceived = Math.min(this.getCapacity(stack) - energy, Math.min(this.getMaxReceive(stack), maxReceive));
            if (!simulate) {
                ItemNBTHelper.setLong(stack, "energy", energy += energyReceived);
            }
            return energyReceived;
        }
        return 0L;
    }

    protected long extractEnergy(ItemStack stack, long maxExtract, boolean simulate) {
        if (this.getMaxExtract(stack) > 0L) {
            long energy = ItemNBTHelper.getLong(stack, "energy", 0L);
            long energyExtracted = Math.min(energy, Math.min(this.getMaxExtract(stack), maxExtract));
            if (!simulate) {
                ItemNBTHelper.setLong(stack, "energy", energy -= energyExtracted);
            }
            return energyExtracted;
        }
        return 0L;
    }

    public long getEnergyStored(ItemStack stack) {
        return ItemNBTHelper.getLong(stack, "energy", 0L);
    }

    protected long getEnergyStored(ItemStack stack, boolean isOPAsking) {
        return this.getEnergyStored(stack);
    }

    public void setEnergy(ItemStack stack, long energy) {
        ItemNBTHelper.setLong(stack, "energy", MathUtils.clamp(energy, 0L, this.getCapacity(stack)));
    }

    public void modifyEnergy(ItemStack stack, long modify) {
        long energy = ItemNBTHelper.getLong(stack, "energy", 0L);
        ItemNBTHelper.setLong(stack, "energy", MathUtils.clamp(energy + modify, 0L, this.getCapacity(stack)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getCapacity(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        long es = this.getEnergyStored(stack, true);
        long mes = this.getCapacity(stack);
        return 1.0 - (double)es / (double)mes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        InfoHelper.addEnergyInfo(stack, tooltip);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new OPMultiProvider((LazyOptional<IOPStorage>)LazyOptional.of(() -> new OPStorageItem(stack)), null);
    }

    private class OPStorageItem
    implements IOPStorage {
        private ItemStack stack;

        public OPStorageItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public long receiveOP(long maxReceive, boolean simulate) {
            return ItemEnergyBase.this.receiveEnergy(this.stack, maxReceive, simulate);
        }

        @Override
        public long extractOP(long maxExtract, boolean simulate) {
            return ItemEnergyBase.this.extractEnergy(this.stack, maxExtract, simulate);
        }

        @Override
        public long getOPStored() {
            return ItemEnergyBase.this.getEnergyStored(this.stack, true);
        }

        @Override
        public long getMaxOPStored() {
            return ItemEnergyBase.this.getCapacity(this.stack);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        @Override
        public int getEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, ItemEnergyBase.this.getEnergyStored(this.stack, false));
        }

        @Override
        public int getMaxEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getMaxOPStored());
        }

        @Override
        public boolean canExtract() {
            return ItemEnergyBase.this.getMaxExtract(this.stack) > 0L;
        }

        @Override
        public boolean canReceive() {
            return ItemEnergyBase.this.getMaxReceive(this.stack) > 0L;
        }
    }
}

