/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ContainerBCore<D>
extends Container {
    protected PlayerEntity player;
    protected ContainerSlotLayout.LayoutFactory<D> factory;
    protected ContainerSlotLayout slotLayout;

    public ContainerBCore(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        super(type, windowId);
        this.player = playerInv.field_70458_d;
    }

    public ContainerBCore(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, PacketBuffer extraData, ContainerSlotLayout.LayoutFactory<D> factory) {
        this(type, windowId, player, extraData);
        this.factory = factory;
        this.buildSlotLayout();
    }

    public ContainerBCore(@Nullable ContainerType<?> type, int windowId, PlayerInventory player) {
        super(type, windowId);
        this.player = player.field_70458_d;
    }

    public ContainerBCore(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, ContainerSlotLayout.LayoutFactory<D> factory) {
        this(type, windowId, player);
        this.player = player.field_70458_d;
        this.factory = factory;
        this.buildSlotLayout();
    }

    protected void buildSlotLayout() {
        this.slotLayout = this.factory.buildLayout(this.player, null).retrieveSlotsForContainer(arg_0 -> ((ContainerBCore)this).func_75146_a(arg_0));
    }

    public ContainerBCore addPlayerSlots(int posX, int posY) {
        return this.addPlayerSlots(posX, posY, 4);
    }

    public ContainerBCore addPlayerSlots(int posX, int posY, int hotbarSpacing) {
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotCheckValid.IInv((IInventory)this.player.field_71071_by, x, posX + 18 * x, posY + 54 + hotbarSpacing));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotCheckValid.IInv((IInventory)this.player.field_71071_by, x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
        return this;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int i) {
        LazyOptional<IItemHandler> optional;
        int playerSlots = 36;
        if (this.slotLayout != null) {
            playerSlots = this.slotLayout.getPlayerSlotCount();
        }
        if ((optional = this.getItemHandler()).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse((Object)EmptyHandler.INSTANCE);
            Slot slot = this.func_75139_a(i);
            if (slot != null && slot.func_75216_d()) {
                ItemStack stack = slot.func_75211_c();
                ItemStack result = stack.func_77946_l();
                if (i >= playerSlots ? !this.func_75135_a(stack, 0, playerSlots, false) : !this.func_75135_a(stack, playerSlots, playerSlots + handler.getSlots(), false)) {
                    return ItemStack.field_190927_a;
                }
                if (stack.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                slot.func_190901_a(player, stack);
                return result;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        Slot slot = this.func_75139_a(slotID);
        if (slot != null) {
            slot.func_75215_d(stack);
        }
    }

    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.func_75139_a(i);
            if (slot == null) continue;
            slot.func_75215_d(stacks.get(i));
        }
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return LazyOptional.empty();
    }

    public ContainerSlotLayout getSlotLayout() {
        return this.slotLayout;
    }
}

