/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.utils;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class SimpleAnimHandler {
    public final IAnimationStateMachine asm;
    private final VariableTickValue animPos = new VariableTickValue(0.0f);
    private float position = 0.0f;
    private float speed = 0.0f;
    private float targetSpeed;
    private float transitionRate;

    public SimpleAnimHandler(ResourceLocation asm) {
        this.asm = BrandonsCore.proxy.loadASM(asm, (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"anim_pos", (Object)this.animPos));
    }

    public void setSpeed(float targetSpeed, float transitionRate) {
        this.targetSpeed = targetSpeed * 0.1f;
        this.transitionRate = transitionRate * 0.005f;
    }

    public void updateAnimation() {
        if (this.speed != this.targetSpeed) {
            this.speed = MathHelper.approachLinear((float)this.speed, (float)this.targetSpeed, (float)this.transitionRate);
        }
        this.position += this.speed;
        this.animPos.setValue(this.position, this.speed);
    }

    public static final class VariableTickValue
    implements ITimeValue {
        private float output;
        private float modifier;

        public VariableTickValue(float initialValue) {
            this.output = initialValue;
        }

        public void setValue(float newValue, float modifier) {
            this.output = newValue;
            this.modifier = modifier;
        }

        public float apply(float input) {
            return this.output + Animation.getPartialTickTime() * this.modifier;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.output), Float.valueOf(this.modifier)});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableTickValue other = (VariableTickValue)obj;
            return this.output == other.output && this.modifier == other.modifier;
        }
    }
}

