/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;

public class GuiTextField
extends GuiElement<GuiTextField> {
    private int maxStringLength = 64;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean canFocus = true;
    private boolean isFocused;
    private boolean isFieldEnabled = true;
    private boolean blinkCursor = false;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int cursorColor = -3092272;
    private Supplier<Integer> textColourSupplier;
    private int disabledColor = 0x707070;
    private boolean shadow = true;
    private Supplier<Boolean> shadowSupplier;
    private Consumer<String> changeListener;
    private Consumer<String> returnListener;
    private Consumer<Boolean> focusListener;
    private Predicate<String> validator = s -> true;
    private Consumer<String> linkedSetter;
    private Supplier<String> linkedGetter;
    private GuiColourProvider.HoverColour<Integer> fillColour = h -> -10526880;
    private GuiColourProvider.HoverColour<Integer> borderColour = h -> -16777216;
    private boolean shiftCache;
    private String suggestion;
    public int textZOffset = 0;
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;
    private Runnable onFinishEdit;
    private String defaultTextStorage = "";

    public GuiTextField() {
    }

    public GuiTextField(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiTextField(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.lineScrollOffset = 0;
        this.updateCursor(0);
        if (!this.shiftCache) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public GuiTextField setChangeListener(Consumer<String> changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public GuiTextField setReturnListener(Consumer<String> returnListener) {
        this.returnListener = returnListener;
        return this;
    }

    public GuiTextField setChangeListener(Runnable changeListener) {
        return this.setChangeListener((String s) -> changeListener.run());
    }

    public GuiTextField setReturnListener(Runnable returnListener) {
        return this.setReturnListener((String s) -> returnListener.run());
    }

    public GuiTextField setFocusListener(Consumer<Boolean> focusListener) {
        this.focusListener = focusListener;
        return this;
    }

    public GuiTextField setTextFormatter(BiFunction<String, Integer, String> textFormatter) {
        this.textFormatter = textFormatter;
        return this;
    }

    public GuiTextField setTextAndNotify(String textIn) {
        boolean changed = !textIn.equals(this.getText());
        this.setText(textIn);
        if (changed) {
            this.notifyListeners(textIn);
        }
        return this;
    }

    public GuiTextField setText(String textIn) {
        if (this.validator.test(textIn)) {
            if (textIn.length() > this.maxStringLength) {
                this.text(textIn.substring(0, this.maxStringLength));
            } else {
                this.text(textIn);
            }
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
        }
        return this;
    }

    public GuiTextField setTextQuietly(String newText) {
        if (newText.length() > this.maxStringLength) {
            this.text(newText.substring(0, this.maxStringLength));
        } else {
            this.text(newText);
        }
        this.setCursorPositionEnd();
        this.setSelectionPos(this.cursorPosition);
        return this;
    }

    public String getText() {
        return this.text();
    }

    public String getSelectedText() {
        int start = Math.min(this.cursorPosition, this.selectionEnd);
        int end = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text().substring(start, end);
    }

    public GuiTextField setValidator(Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        int selectStart = Math.min(this.cursorPosition, this.selectionEnd);
        int selectEnd = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text().length() - (selectStart - selectEnd);
        if (!this.text().isEmpty()) {
            s = s + this.text().substring(0, selectStart);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text().isEmpty() && selectEnd < this.text().length()) {
            s = s + this.text().substring(selectEnd);
        }
        if (this.validator.test(s)) {
            this.text(s);
            this.updateCursor(selectStart + l);
            this.setSelectionPos(this.cursorPosition);
            this.notifyListeners(this.text());
        }
    }

    private void notifyListeners(String newText) {
        if (this.changeListener != null) {
            this.changeListener.accept(newText);
        }
    }

    private void delete(int dir) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(dir);
        } else {
            this.deleteFromCursor(dir);
        }
    }

    public void deleteWords(int num) {
        if (!this.text().isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text().isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = this.text().substring(0, i);
                }
                if (j < this.text().length()) {
                    s = s + this.text().substring(j);
                }
                if (this.validator.test(s)) {
                    this.text(s);
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                    this.notifyListeners(this.text());
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text().length();
                i = this.text().indexOf(32, i);
                if (i == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text().charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text().charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text().charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void setCursorPosition(int pos) {
        this.updateCursor(pos);
        if (!this.shiftCache) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void updateCursor(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text().length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text().length());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isEditing()) {
            return false;
        }
        this.shiftCache = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            if (this.isFieldEnabled) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.isFieldEnabled) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 257: {
                if (this.onFinishEdit != null) {
                    this.onFinishEdit.run();
                }
                if (this.returnListener != null) {
                    this.returnListener.accept(this.getText());
                    return true;
                }
                return false;
            }
            case 259: {
                if (this.isFieldEnabled) {
                    this.shiftCache = false;
                    this.delete(-1);
                    this.shiftCache = Screen.func_231173_s_();
                }
                return true;
            }
            default: {
                return keyCode != 256;
            }
            case 261: {
                if (this.isFieldEnabled) {
                    this.shiftCache = false;
                    this.delete(1);
                    this.shiftCache = Screen.func_231173_s_();
                }
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean isEditing() {
        return this.isFocused() && this.isFieldEnabled;
    }

    @Override
    public boolean charTyped(char charType, int charCode) {
        if (!this.isEditing()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)charType)) {
            if (this.isFieldEnabled) {
                this.writeText(Character.toString(charType));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.canFocus) {
            this.setFocused(true);
        } else if (!mouseOver && this.canLoseFocus) {
            this.setFocused(false);
        }
        if (this.isFocused() && mouseOver && button == 0) {
            int i = MathHelper.func_76128_c((double)mouseX) - this.xPos();
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.fontRenderer.func_238412_a_(this.text().substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.func_238412_a_(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    @Override
    public void globalClick(double mouseX, double mouseY, int button) {
        super.globalClick(mouseX, mouseY, button);
        if (this.isFocused() && this.canLoseFocus && !this.isMouseOver(mouseX, mouseY)) {
            this.setFocused(false);
        }
    }

    public void drawTextBox(MatrixStack matrixStack, boolean mouseOver) {
        if (this.getEnableBackgroundDrawing()) {
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, this.getFillColour(mouseOver), this.getBorderColour(mouseOver));
        }
        double zLevel = this.getRenderZLevel();
        int i = this.isFieldEnabled ? this.getTextColor() : this.disabledColor;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.fontRenderer.func_238412_a_(this.text().substring(this.lineScrollOffset), this.getAdjustedWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused() && this.cursorCounter / 10 % 2 == 0 && flag;
        int stringX = this.enableBackgroundDrawing ? this.xPos() + 4 : this.xPos();
        int stringY = this.enableBackgroundDrawing ? this.yPos() + (this.ySize() - 8) / 2 : this.yPos();
        int j1 = stringX;
        if (k > s.length()) {
            k = s.length();
        }
        matrixStack.func_227861_a_(0.0, 0.0, (double)this.textZOffset + zLevel);
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.getShadow() ? this.fontRenderer.func_238405_a_(matrixStack, this.textFormatter.apply(s1, this.lineScrollOffset), stringX, stringY, i) : this.fontRenderer.func_238421_b_(matrixStack, this.textFormatter.apply(s1, this.lineScrollOffset), stringX, stringY, i);
        }
        boolean flag2 = this.cursorPosition < this.text().length() || this.text().length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? stringX + this.xSize() : stringX;
        } else if (flag2) {
            k1 = j1 - 1;
            if (this.getShadow()) {
                --j1;
            }
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            if (this.getShadow()) {
                this.fontRenderer.func_238405_a_(matrixStack, this.textFormatter.apply(s.substring(j), this.cursorPosition), j1, stringY, i);
            } else {
                this.fontRenderer.func_238421_b_(matrixStack, this.textFormatter.apply(s.substring(j), this.cursorPosition), j1, stringY, i);
            }
        }
        if (!flag2 && this.suggestion != null) {
            if (this.getShadow()) {
                this.fontRenderer.func_238405_a_(matrixStack, this.suggestion, k1 - 1, stringY, -8355712);
            } else {
                this.fontRenderer.func_238421_b_(matrixStack, this.suggestion, k1 - 1, stringY, -8355712);
            }
        }
        if (flag1) {
            if (flag2) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)k1, (int)(stringY - 1), (int)(k1 + 1), (int)(stringY + 1 + 9), (int)this.cursorColor);
            } else if (this.getShadow()) {
                this.fontRenderer.func_238405_a_(matrixStack, "_", k1, stringY, i);
            } else {
                this.fontRenderer.func_238421_b_(matrixStack, "_", k1, stringY, i);
            }
        }
        if (k != j) {
            int l1 = stringX + this.fontRenderer.func_78256_a(s.substring(0, k));
            this.drawSelectionBox(k1, stringY - 1, l1 - 1, stringY + 1 + 9);
        }
        matrixStack.func_227861_a_(0.0, 0.0, -((double)this.textZOffset + zLevel));
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.xPos() + this.xSize()) {
            endX = this.xPos() + this.xSize();
        }
        if (startX > this.xPos() + this.xSize()) {
            startX = this.xPos() + this.xSize();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public GuiTextField setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text().length() > length) {
            this.text(this.text().substring(0, length));
            this.notifyListeners(this.text());
        }
        return this;
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public GuiTextField setEnableBackgroundDrawing(boolean enableBackgroundDrawingIn) {
        this.enableBackgroundDrawing = enableBackgroundDrawingIn;
        return this;
    }

    public GuiTextField setTextColor(int color) {
        this.enabledColor = color;
        return this;
    }

    public GuiTextField setTextColor(Supplier<Integer> color) {
        this.textColourSupplier = color;
        return this;
    }

    public GuiTextField setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
        return this;
    }

    public GuiTextField setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextField setShadowSupplier(Supplier<Boolean> shadowSupplier) {
        this.shadowSupplier = shadowSupplier;
        return this;
    }

    public boolean getShadow() {
        return this.shadowSupplier == null ? this.shadow : this.shadowSupplier.get();
    }

    public int getTextColor() {
        return this.textColourSupplier == null ? this.enabledColor : this.textColourSupplier.get();
    }

    public GuiTextField setDisabledTextColour(int color) {
        this.disabledColor = color;
        return this;
    }

    public boolean changeFocus(boolean noOp) {
        if (this.isFieldEnabled) {
            this.isFocused = !this.isFocused;
            this.onFocusedChanged(this.isFocused);
            return this.isFocused;
        }
        return false;
    }

    protected void onFocusedChanged(boolean newFocus) {
        if (newFocus) {
            this.cursorCounter = 0;
        }
        if (this.focusListener != null) {
            this.focusListener.accept(newFocus);
        }
        if (!newFocus && this.onFinishEdit != null) {
            this.onFinishEdit.run();
        }
    }

    public void setFocused(boolean isFocusedIn) {
        if (isFocusedIn != this.isFocused) {
            this.onFocusedChanged(isFocusedIn);
        }
        this.isFocused = isFocusedIn;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public GuiTextField setFieldEnabled(boolean enabled) {
        this.isFieldEnabled = enabled;
        return this;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.xSize() - 8 : this.xSize();
    }

    public void setSelectionPos(int position) {
        int texLen = this.text().length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)texLen);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > texLen) {
                this.lineScrollOffset = texLen;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.func_238412_a_(this.text().substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_238413_a_(this.text(), j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)texLen);
        }
    }

    public GuiTextField setCanFocus(boolean canFocus) {
        this.canFocus = canFocus;
        return this;
    }

    public GuiTextField setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
        return this;
    }

    public GuiTextField setColours(int fillColour, int borderColour) {
        this.fillColour = h -> fillColour;
        this.borderColour = h -> borderColour;
        return this;
    }

    public int getFillColour(boolean hovering) {
        return this.fillColour.getColour(hovering);
    }

    public int getBorderColour(boolean hovering) {
        return this.borderColour.getColour(hovering);
    }

    public GuiTextField setFillColour(GuiColourProvider.HoverColour<Integer> fillColour) {
        this.fillColour = fillColour;
        return this;
    }

    public GuiTextField setBorderColour(GuiColourProvider.HoverColour<Integer> borderColour) {
        this.borderColour = borderColour;
        return this;
    }

    public void setSuggestion(@Nullable String p_195612_1_) {
        this.suggestion = p_195612_1_;
    }

    public GuiTextField setLinkedValue(Supplier<String> linkedGetter, Consumer<String> linkedSetter) {
        this.linkedGetter = linkedGetter;
        this.linkedSetter = linkedSetter;
        return this;
    }

    public GuiTextField setBlinkingCursor(boolean blinkCursor) {
        this.blinkCursor = blinkCursor;
        return this;
    }

    public boolean isBlinkCursor() {
        return this.blinkCursor;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.drawTextBox(new MatrixStack(), this.isMouseOver(mouseX, mouseY));
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        if (super.onUpdate()) {
            return true;
        }
        this.cursorCounter = this.blinkCursor ? ++this.cursorCounter : 0;
        return false;
    }

    private String text() {
        return this.linkedGetter == null ? this.defaultTextStorage : this.linkedGetter.get();
    }

    private void text(String text) {
        if (this.linkedSetter != null) {
            this.linkedSetter.accept(text);
        } else {
            this.defaultTextStorage = text;
        }
    }

    public void onFinishEdit(Runnable onFinishEdit) {
        this.onFinishEdit = onFinishEdit;
    }
}

