/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.render.GuiSpriteUploader;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;

public class BCSprites {
    public static final ResourceLocation LOCATION_GUI_ATLAS = new ResourceLocation("brandonscore", "textures/atlas/gui.png");
    public static final String RESOURCE_PREFIX = "brandonscore".toLowerCase(Locale.ENGLISH) + ":";
    private static GuiSpriteUploader guiSpriteUploader;
    private static final Set<ResourceLocation> registeredSprites;
    private static final Map<String, RenderMaterial> matCache;
    public static final RenderType GUI_TYPE;
    private static String[] ARMOR_ORDER;
    @Deprecated
    public static final ResourceLocation MODULAR_GUI;

    public static void initialize(ColorHandlerEvent.Block event) {
        guiSpriteUploader = new GuiSpriteUploader(registeredSprites);
        Stream.of(GuiToolkit.GuiLayout.values()).filter(e -> e.xSize != -1).forEach(layout -> BCSprites.registerThemed("brandonscore", layout.textureName()));
        BCSprites.registerThemed("brandonscore", "background_dynamic");
        BCSprites.registerThemed("brandonscore", "bg_dynamic_small");
        BCSprites.registerThemed("brandonscore", "borderless_bg_dynamic_small");
        BCSprites.registerThemed("brandonscore", "button");
        BCSprites.registerThemed("brandonscore", "button_highlight");
        BCSprites.registerThemed("brandonscore", "button_disabled");
        BCSprites.registerThemed("brandonscore", "button_borderless");
        BCSprites.registerThemed("brandonscore", "button_borderless_invert");
        BCSprites.registerThemed("brandonscore", "slot");
        BCSprites.registerThemed("brandonscore", "slot_large");
        BCSprites.registerThemed("brandonscore", "resize");
        BCSprites.registerThemed("brandonscore", "reposition");
        BCSprites.registerThemed("brandonscore", "copy");
        BCSprites.registerThemed("brandonscore", "theme");
        BCSprites.registerThemed("brandonscore", "gear");
        BCSprites.registerThemed("brandonscore", "advanced");
        BCSprites.registerThemed("brandonscore", "arrow_left");
        BCSprites.registerThemed("brandonscore", "arrow_right");
        BCSprites.registerThemed("brandonscore", "expand_content");
        BCSprites.registerThemed("brandonscore", "collapse_content");
        BCSprites.registerThemed("brandonscore", "preset_icon");
        BCSprites.registerThemed("brandonscore", "global_icon");
        BCSprites.registerThemed("brandonscore", "global_icon_inactive");
        BCSprites.registerThemed("brandonscore", "global_key_icon");
        BCSprites.registerThemed("brandonscore", "grid_small");
        BCSprites.registerThemed("brandonscore", "grid_large");
        BCSprites.registerThemed("brandonscore", "item_config");
        BCSprites.registerThemed("brandonscore", "hud_button");
        BCSprites.registerThemed("brandonscore", "info_icon");
        BCSprites.registerThemed("brandonscore", "prog_arrow_right");
        BCSprites.registerThemed("brandonscore", "prog_arrow_right_over");
        BCSprites.registerThemed("brandonscore", "prog_arrow_up");
        BCSprites.registerThemed("brandonscore", "prog_arrow_up_over");
        BCSprites.registerThemed("brandonscore", "prog_arrow_up_tall");
        BCSprites.registerThemed("brandonscore", "prog_arrow_up_tall_over");
        BCSprites.register("brandonscore", "add");
        BCSprites.register("brandonscore", "delete");
        BCSprites.register("brandonscore", "delete_all");
        BCSprites.register("brandonscore", "info_panel");
        BCSprites.register("brandonscore", "reposition_gray");
        BCSprites.register("brandonscore", "new_group");
        BCSprites.register("brandonscore", "redstone/always_active");
        BCSprites.register("brandonscore", "redstone/active_high");
        BCSprites.register("brandonscore", "redstone/active_low");
        BCSprites.register("brandonscore", "redstone/never_active");
        BCSprites.register("brandonscore", "slots/fuel");
        BCSprites.register("brandonscore", "slots/energy");
        BCSprites.register("brandonscore", "slots/armor_boots");
        BCSprites.register("brandonscore", "slots/armor_chestplate");
        BCSprites.register("brandonscore", "slots/armor_helmet");
        BCSprites.register("brandonscore", "slots/armor_leggings");
        BCSprites.register("brandonscore", "slots/armor_shield");
        BCSprites.register("brandonscore", "slots/sword");
        BCSprites.register("brandonscore", "item_charge/btn_right_charge");
        BCSprites.register("brandonscore", "item_charge/btn_right_discharge");
        BCSprites.register("brandonscore", "item_charge/btn_right_disabled");
        BCSprites.register("brandonscore", "item_charge/btn_right_both");
        BCSprites.register("brandonscore", "item_charge/btn_vertical_charge");
        BCSprites.register("brandonscore", "item_charge/btn_vertical_discharge");
        BCSprites.register("brandonscore", "item_charge/btn_vertical_disabled");
        BCSprites.register("brandonscore", "item_charge/btn_vertical_both");
        BCSprites.register("brandonscore", "item_charge/horizontal_charge");
        BCSprites.register("brandonscore", "item_charge/horizontal_discharge");
        BCSprites.register("brandonscore", "item_charge/right_charge");
        BCSprites.register("brandonscore", "item_charge/right_discharge");
        BCSprites.register("brandonscore", "item_charge/vertical_charge");
        BCSprites.register("brandonscore", "item_charge/vertical_discharge");
        BCSprites.register("brandonscore", "bars/food_empty");
        BCSprites.register("brandonscore", "bars/food_half");
        BCSprites.register("brandonscore", "bars/food_full");
        BCSprites.register("brandonscore", "bars/energy_empty");
        BCSprites.register("brandonscore", "bars/energy_full");
        BCSprites.register("brandonscore", "downloading");
        BCSprites.register("brandonscore", "download_failed");
    }

    public static void registerThemed(String modid, String location) {
        BCSprites.register(modid, "light/" + location);
        BCSprites.register(modid, "dark/" + location);
    }

    public static void register(String modid, String location) {
        BCSprites.register(new ResourceLocation(modid, location));
    }

    public static void register(ResourceLocation location) {
        registeredSprites.add(location);
    }

    public static RenderMaterial getThemed(String modid, String location) {
        return BCSprites.get(modid, (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static RenderMaterial getThemed(String location) {
        return BCSprites.get("brandonscore", (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static RenderMaterial get(String modid, String location) {
        return matCache.computeIfAbsent(modid + ":" + location, s -> new CustomMat(LOCATION_GUI_ATLAS, new ResourceLocation(modid, location)));
    }

    public static RenderMaterial get(String location) {
        return BCSprites.get("brandonscore", location);
    }

    public static TextureAtlasSprite getSprite(String location) {
        return BCSprites.get(location).func_229314_c_();
    }

    public static Supplier<RenderMaterial> themedGetter(String modid, String location) {
        return () -> BCSprites.get(modid, (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Supplier<RenderMaterial> themedGetter(String location) {
        return () -> BCSprites.get("brandonscore", (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Supplier<RenderMaterial> getter(String modid, String location) {
        return () -> matCache.computeIfAbsent(modid + ":" + location, s -> new CustomMat(LOCATION_GUI_ATLAS, new ResourceLocation(modid, location)));
    }

    public static Supplier<RenderMaterial> getter(String location) {
        return () -> BCSprites.get("brandonscore", location);
    }

    public static RenderMaterial getButton(int state) {
        return BCSprites.getThemed(state == 1 ? "button" : (state == 2 ? "button_highlight" : "button_disabled"));
    }

    public static RenderMaterial getArmorSlot(int slot) {
        return BCSprites.get(ARMOR_ORDER[slot]);
    }

    public static RenderType makeType(ResourceLocation location) {
        return RenderType.func_228632_a_((String)"sprite_type", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(location, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    }

    public static IVertexBuilder builder(IRenderTypeBuffer getter, MatrixStack mStack) {
        return new TransformingVertexBuilder(getter.getBuffer(GUI_TYPE), mStack);
    }

    public static IVertexBuilder builder(IRenderTypeBuffer getter) {
        return getter.getBuffer(GUI_TYPE);
    }

    static {
        registeredSprites = new HashSet<ResourceLocation>();
        matCache = new HashMap<String, RenderMaterial>();
        GUI_TYPE = RenderType.func_228632_a_((String)"gui_tex", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(LOCATION_GUI_ATLAS, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228714_a_(RenderState.field_228491_A_).func_228713_a_(RenderState.field_228517_i_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
        ARMOR_ORDER = new String[]{"slots/armor_boots", "slots/armor_leggings", "slots/armor_chestplate", "slots/armor_helmet"};
        MODULAR_GUI = new ResourceLocation(RESOURCE_PREFIX + "textures/gui/modular_gui.png");
    }

    private static class CustomMat
    extends RenderMaterial {
        public CustomMat(ResourceLocation atlasLocationIn, ResourceLocation textureLocationIn) {
            super(atlasLocationIn, textureLocationIn);
        }

        public TextureAtlasSprite func_229314_c_() {
            return guiSpriteUploader.func_215282_a(this.func_229313_b_());
        }
    }
}

