/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.power;

import com.brandon3055.brandonscore.api.power.IOInfo;
import javax.annotation.Nullable;
import net.minecraftforge.energy.IEnergyStorage;

public interface IOPStorage
extends IEnergyStorage {
    default public long receiveOP(long maxReceive, boolean simulate) {
        return this.receiveEnergy((int)Math.min(maxReceive, Integer.MAX_VALUE), simulate);
    }

    default public long extractOP(long maxExtract, boolean simulate) {
        return this.extractEnergy((int)Math.min(maxExtract, Integer.MAX_VALUE), simulate);
    }

    default public long getOPStored() {
        return this.getEnergyStored();
    }

    default public long getMaxOPStored() {
        return this.getMaxEnergyStored();
    }

    public boolean canExtract();

    public boolean canReceive();

    @Nullable
    default public IOInfo getIOInfo() {
        return null;
    }

    default public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.receiveOP(maxReceive, simulate);
    }

    default public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.extractOP(maxExtract, simulate);
    }

    default public int getEnergyStored() {
        return (int)Math.min(this.getOPStored(), Integer.MAX_VALUE);
    }

    default public int getMaxEnergyStored() {
        return (int)Math.min(this.getMaxOPStored(), Integer.MAX_VALUE);
    }
}

