/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api;

import java.util.Locale;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum TechLevel {
    DRACONIUM(0, TextFormatting.WHITE, Rarity.COMMON, 3),
    WYVERN(1, TextFormatting.BLUE, Rarity.UNCOMMON, 32),
    DRACONIC(2, TextFormatting.GOLD, Rarity.RARE, 128),
    CHAOTIC(3, TextFormatting.DARK_PURPLE, Rarity.EPIC, 512);

    public final int index;
    private final TextFormatting textColour;
    private Rarity rarity;
    private final int harvestLevel;
    private IItemTier itemTier;
    public static final TechLevel[] VALUES;
    public static final TechLevel[] TOOL_LEVELS;

    private TechLevel(int index, TextFormatting colour, Rarity rarity, int harvestLevel) {
        this.index = index;
        this.textColour = colour;
        this.rarity = rarity;
        this.harvestLevel = harvestLevel;
    }

    public TextFormatting getTextColour() {
        return this.textColour;
    }

    public TextComponent getDisplayName() {
        return new TranslationTextComponent("tech_level.draconicevolution." + this.name().toLowerCase(Locale.ENGLISH));
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public static TechLevel byIndex(int index) {
        return index >= 0 && index < VALUES.length ? VALUES[index] : DRACONIUM;
    }

    static {
        VALUES = new TechLevel[4];
        TOOL_LEVELS = new TechLevel[3];
        TechLevel[] techLevelArray = TechLevel.values();
        int n = techLevelArray.length;
        for (int i = 0; i < n; ++i) {
            TechLevel tier;
            TechLevel.VALUES[tier.index] = tier = techLevelArray[i];
            if (tier == DRACONIUM) continue;
            TechLevel.TOOL_LEVELS[tier.index - 1] = tier;
        }
    }
}

