/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.api.events.BotanyPotHarvestedEvent;
import net.darkhax.botanypots.api.events.CropPlaceEvent;
import net.darkhax.botanypots.api.events.CropRemovedEvent;
import net.darkhax.botanypots.api.events.FertilizerUsedEvent;
import net.darkhax.botanypots.api.events.LookupEvent;
import net.darkhax.botanypots.api.events.SoilPlaceEvent;
import net.darkhax.botanypots.api.events.SoilRemoveEvent;
import net.darkhax.botanypots.api.events.SoilValidForCropEvent;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockBotanyPot
extends Block
implements IGrowable,
IWaterLoggable {
    private static final ITextComponent TOOLTIP_NORMAL = new TranslationTextComponent("botanypots.tooltip.pot.normal").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_HOPPER = new TranslationTextComponent("botanypots.tooltip.pot.hopper").func_240699_a_(TextFormatting.GRAY);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(1.25f, 4.2f).func_226896_b_();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final boolean hopper;
    public static List<Block> botanyPots = NonNullList.func_191196_a();

    public BlockBotanyPot() {
        this(false);
    }

    public BlockBotanyPot(boolean hopper) {
        super(properties);
        this.hopper = hopper;
        botanyPots.add(this);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isHopper() {
        return this.hopper;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (player.func_225608_bj_()) {
                CropInfo crop = pot.getCrop();
                if (crop != null) {
                    if (MinecraftForge.EVENT_BUS.post((Event)new CropRemovedEvent.Pre(pot, player, crop))) {
                        return ActionResultType.FAIL;
                    }
                    if (pot.canSetCrop(null)) {
                        ItemStack seedStack = pot.getCropStack();
                        if (!seedStack.func_190926_b()) {
                            BlockBotanyPot.dropItem(seedStack.func_77946_l(), world, pos);
                        }
                        pot.setCrop(null, ItemStack.field_190927_a);
                        MinecraftForge.EVENT_BUS.post((Event)new CropRemovedEvent.Post(pot, player, crop));
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    ItemStack soilStack;
                    SoilInfo soil = pot.getSoil();
                    if (soil != null && !MinecraftForge.EVENT_BUS.post((Event)new SoilRemoveEvent.Pre(pot, soil, player)) && !(soilStack = pot.getSoilStack()).func_190926_b() && pot.canSetSoil(null)) {
                        pot.setSoil(null, ItemStack.field_190927_a);
                        BlockBotanyPot.dropItem(soilStack.func_77946_l(), world, pos);
                        MinecraftForge.EVENT_BUS.post((Event)new SoilRemoveEvent.Post(pot, soil, player));
                        return ActionResultType.SUCCESS;
                    }
                }
            } else {
                ItemStack heldItem = player.func_184586_b(hand);
                if (!heldItem.func_190926_b()) {
                    int ticksToGrow;
                    FertilizerUsedEvent.Pre preEvent;
                    FertilizerInfo fertilizerForStack;
                    LookupEvent lookupEvent;
                    if (pot.getSoil() == null) {
                        SoilPlaceEvent.Pre preEvent2;
                        SoilInfo soilForStack = BotanyPotHelper.getSoilForItem(heldItem);
                        lookupEvent = new LookupEvent.Soil(pot, player, soilForStack, heldItem);
                        if (!MinecraftForge.EVENT_BUS.post((Event)lookupEvent) && lookupEvent.getCurrentLookup() != null && !MinecraftForge.EVENT_BUS.post((Event)(preEvent2 = new SoilPlaceEvent.Pre(pot, soilForStack = (SoilInfo)((Object)lookupEvent.getCurrentLookup()), player))) && preEvent2.getCurrentSoil() != null && (soilForStack = preEvent2.getCurrentSoil()) != null && pot.canSetSoil(soilForStack)) {
                            ItemStack inStack = heldItem.func_77946_l();
                            inStack.func_190920_e(1);
                            pot.setSoil(soilForStack, inStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            MinecraftForge.EVENT_BUS.post((Event)new SoilPlaceEvent.Post(pot, soilForStack, player));
                            return ActionResultType.SUCCESS;
                        }
                    } else if (pot.getCrop() == null) {
                        CropPlaceEvent.Pre preEvent3;
                        CropInfo cropForStack = BotanyPotHelper.getCropForItem(heldItem);
                        lookupEvent = new LookupEvent.Crop(pot, player, cropForStack, heldItem);
                        if (!MinecraftForge.EVENT_BUS.post((Event)lookupEvent) && lookupEvent.getCurrentLookup() != null && !MinecraftForge.EVENT_BUS.post((Event)(preEvent3 = new CropPlaceEvent.Pre(pot, player, cropForStack = (CropInfo)((Object)lookupEvent.getCurrentLookup())))) && preEvent3.getCurrentCrop() != null) {
                            cropForStack = preEvent3.getCurrentCrop();
                            boolean isSoilValid = BotanyPotHelper.isSoilValidForCrop(pot.getSoil(), cropForStack);
                            SoilValidForCropEvent validSoilEvent = new SoilValidForCropEvent(pot, player, pot.getSoil(), cropForStack, isSoilValid);
                            boolean bl = isSoilValid = !MinecraftForge.EVENT_BUS.post((Event)validSoilEvent) && validSoilEvent.isSoilValid();
                            if (isSoilValid && pot.canSetCrop(cropForStack)) {
                                ItemStack inStack = heldItem.func_77946_l();
                                inStack.func_190920_e(1);
                                pot.setCrop(cropForStack, inStack);
                                if (!player.func_184812_l_()) {
                                    heldItem.func_190918_g(1);
                                }
                                MinecraftForge.EVENT_BUS.post((Event)new CropPlaceEvent.Post(pot, player, cropForStack));
                                return ActionResultType.SUCCESS;
                            }
                        }
                    } else if (!(pot.canHarvest() || MinecraftForge.EVENT_BUS.post((Event)(lookupEvent = new LookupEvent.Fertilizer(pot, player, fertilizerForStack = BotanyPotHelper.getFertilizerForItem(heldItem), heldItem))) || lookupEvent.getCurrentLookup() == null || (fertilizerForStack = (FertilizerInfo)((Object)lookupEvent.getCurrentLookup())) == null || MinecraftForge.EVENT_BUS.post((Event)(preEvent = new FertilizerUsedEvent.Pre(pot, player, fertilizerForStack, heldItem, ticksToGrow = fertilizerForStack.getTicksToGrow(world.field_73012_v, pot.getSoil(), pot.getCrop())))) || preEvent.getCurrentGrowthTicks() <= 0)) {
                        ticksToGrow = preEvent.getCurrentGrowthTicks();
                        pot.addGrowth(ticksToGrow);
                        if (!world.field_72995_K) {
                            world.func_217379_c(2005, tile.func_174877_v(), 0);
                        }
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new FertilizerUsedEvent.Post(pot, player, fertilizerForStack, heldItem, ticksToGrow));
                        return ActionResultType.SUCCESS;
                    }
                }
                if (!this.isHopper() && pot.canHarvest() && !MinecraftForge.EVENT_BUS.post((Event)new BotanyPotHarvestedEvent.Pre(pot, player))) {
                    BotanyPotHarvestedEvent.LootGenerated event = new BotanyPotHarvestedEvent.LootGenerated(pot, player, (List<ItemStack>)BotanyPotHelper.generateDrop(world.field_73012_v, pot.getCrop()));
                    if (!MinecraftForge.EVENT_BUS.post((Event)event) && !event.getDrops().isEmpty()) {
                        for (ItemStack stack : event.getDrops()) {
                            BlockBotanyPot.dropItem(stack, world, pos);
                        }
                    }
                    pot.onCropHarvest();
                    pot.resetGrowthTime();
                    MinecraftForge.EVENT_BUS.post((Event)new BotanyPotHarvestedEvent.Post(pot, player));
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityBotanyPot();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tileEntity;
            if (pot.getSoil() != null) {
                BlockBotanyPot.dropItem(pot.getSoilStack(), worldIn, pos);
            }
            if (pot.getCrop() != null) {
                BlockBotanyPot.dropItem(pot.getCropStack(), worldIn, pos);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public static void dropItem(ItemStack item, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            double offsetX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offsetY = (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity droppedItemEntity = new ItemEntity(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, item);
            droppedItemEntity.func_174869_p();
            world.func_217376_c((Entity)droppedItemEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.isHopper() ? TOOLTIP_HOPPER : TOOLTIP_NORMAL);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            return pot.hasSoilAndCrop() && !pot.isDoneGrowing();
        }
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState myState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            ((TileEntityBotanyPot)tile).addGrowth(MathsUtils.nextIntInclusive((Random)random, (int)3, (int)15) * 20);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tile;
        if (world.func_175667_e(pos) && (tile = world.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            return ((TileEntityBotanyPot)tile).isDoneGrowing() ? 15 : super.func_180641_l(blockState, world, pos);
        }
        return super.func_180641_l(blockState, world, pos);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int light = super.getLightValue(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            int cropLight;
            int soilLight;
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (pot.getSoil() != null && (soilLight = pot.getSoil().getLightLevel(world, pos)) > light) {
                light = soilLight;
            }
            if (pot.getCrop() != null && (cropLight = pot.getCrop().getLightLevel(world, pos)) > light) {
                light = cropLight;
            }
        }
        return light;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

