/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.base.IWorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import de.melanx.botanicalmachinery.helper.RecipeHelper2;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.lib.ModTags;

public class TileMechanicalRunicAltar
extends BotanicalTile
implements IWorkingTile {
    public static final int MAX_MANA_PER_TICK = 100;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(33, slot -> {
        this.update = true;
        this.markDispatchable();
    }, this::isValidStack);
    private IRuneAltarRecipe recipe = null;
    private int progress;
    private int maxProgress;
    private boolean update;
    private final List<Integer> slotsUsed = new ArrayList<Integer>();

    public TileMechanicalRunicAltar(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.mechanicalRunicAltar);
        this.inventory.setInputSlots(IntStream.range(1, 17).toArray());
        this.inventory.setOutputSlots(IntStream.range(17, 33).toArray());
        this.update = true;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (slot == 0) {
            return stack.func_77973_b() == ModBlocks.livingrock.func_199767_j();
        }
        if (Arrays.stream(this.inventory.getInputSlots()).anyMatch(x -> x == slot)) {
            return RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.RUNE_TYPE, (ItemStack)stack);
        }
        return true;
    }

    private void updateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ArrayList stacks = new ArrayList(this.inventory.getStacks());
            RecipeHelper2.removeFromList(stacks, IntStream.range(17, stacks.size() - 1).toArray(), {0});
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                if (!(recipe instanceof IRuneAltarRecipe) || !RecipeHelper.matches((IRecipe)recipe, stacks, (boolean)false) || this.inventory.getStackInSlot(0).func_190926_b()) continue;
                ArrayList<ItemStack> stacksToTest = new ArrayList<ItemStack>();
                stacksToTest.add(recipe.func_77571_b());
                block1: for (Ingredient ingredient : recipe.func_192400_c()) {
                    for (int slot : this.inventory.getInputSlots()) {
                        ItemStack stack = this.inventory.getStackInSlot(slot);
                        if (!ingredient.test(stack) || !ModTags.Items.RUNES.func_230235_a_((Object)stack.func_77973_b())) continue;
                        ItemStack rune = stack.func_77946_l();
                        rune.func_190920_e(1);
                        for (ItemStack testStack : stacksToTest) {
                            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)testStack, (ItemStack)rune)) continue;
                            testStack.func_190917_f(1);
                            break;
                        }
                        stacksToTest.add(rune);
                        continue block1;
                    }
                }
                if (!this.canInsertAll(stacksToTest)) continue;
                this.recipe = (IRuneAltarRecipe)recipe;
                this.slotsUsed.clear();
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    for (int slot : this.inventory.getInputSlots()) {
                        if (this.slotsUsed.contains(slot) || !ingredient.test(this.inventory.getStackInSlot(slot))) continue;
                        this.slotsUsed.add(slot);
                    }
                }
                return;
            }
        }
        this.slotsUsed.clear();
        this.recipe = null;
    }

    @Override
    public boolean hasValidRecipe() {
        if (!this.inventory.isInputEmpty()) {
            return !this.inventory.getStackInSlot(0).func_190926_b();
        }
        return true;
    }

    public void func_73660_a() {
        block9: {
            block7: {
                block8: {
                    if (this.field_145850_b == null || this.field_145850_b.field_72995_K) break block7;
                    if (this.update) {
                        this.updateRecipe();
                        this.func_70296_d();
                        this.update = false;
                    }
                    if (this.recipe == null) break block8;
                    this.maxProgress = this.recipe.getManaUsage();
                    int manaTransfer = Math.min(this.getCurrentMana(), Math.min(this.getMaxManaPerTick(), this.getMaxProgress() - this.progress));
                    this.progress += manaTransfer;
                    this.receiveMana(-manaTransfer);
                    if (this.progress >= this.getMaxProgress()) {
                        ItemStack output = this.recipe.func_77571_b().func_77946_l();
                        block0: for (Ingredient ingredient : this.recipe.func_192400_c()) {
                            for (ItemStack stack : this.inventory.getStacks()) {
                                if (!ingredient.test(stack)) continue;
                                if (ModTags.Items.RUNES.func_230235_a_((Object)stack.func_77973_b())) {
                                    ItemStack rune = stack.func_77946_l();
                                    rune.func_190920_e(1);
                                    this.putIntoOutputOrDrop(rune);
                                }
                                stack.func_190918_g(1);
                                continue block0;
                            }
                        }
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                        this.putIntoOutputOrDrop(output);
                        this.update = true;
                        this.progress = 0;
                        this.maxProgress = -1;
                    }
                    this.func_70296_d();
                    this.markDispatchable();
                    break block9;
                }
                if (this.progress <= 0) break block9;
                this.progress = 0;
                this.maxProgress = -1;
                this.func_70296_d();
                this.markDispatchable();
                break block9;
            }
            if (this.field_145850_b != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory && this.getMaxProgress() > 0 && this.progress >= this.getMaxProgress() - 5 * this.getMaxManaPerTick()) {
                for (int i = 0; i < 5; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle((float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (int)10);
                    this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void putIntoOutputOrDrop(ItemStack stack) {
        ItemStack leftToInsert = stack;
        for (int i : this.inventory.getOutputSlots()) {
            if (stack.func_190926_b() || leftToInsert.func_190926_b()) break;
            leftToInsert = this.inventory.getUnrestricted().insertItem(i, leftToInsert, false);
        }
        if (!leftToInsert.func_190926_b() && !this.field_145850_b.field_72995_K) {
            ItemEntity ie = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.5, leftToInsert.func_77946_l());
            this.field_145850_b.func_217376_c((Entity)ie);
        }
    }

    private boolean canInsertAll(List<ItemStack> stacks) {
        int freeSlotsNeeded = 0;
        for (ItemStack stack : stacks) {
            freeSlotsNeeded += this.freeSlotsNeededFor(stack);
        }
        for (Object i : (Object)this.inventory.getOutputSlots()) {
            ItemStack slotContent = this.inventory.getStackInSlot((int)i);
            if (!slotContent.func_190926_b()) continue;
            --freeSlotsNeeded;
        }
        return freeSlotsNeeded <= 0;
    }

    private int freeSlotsNeededFor(ItemStack stack) {
        int sizeLeft = stack.func_190916_E();
        for (int i : this.inventory.getOutputSlots()) {
            ItemStack slotContent = this.inventory.getStackInSlot(i);
            if (slotContent.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotContent) || (sizeLeft -= Math.min(sizeLeft, slotContent.func_77976_d() - slotContent.func_190916_E())) > 0) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getMaxManaPerTick() {
        return 100 / LibXServerConfig.WorkingDurationMultiplier.mechanicalRunicAltar;
    }

    public boolean isSlotUsedCurrently(int slot) {
        return this.slotsUsed.contains(slot);
    }

    @Override
    public int getComparatorOutput() {
        return this.getProgress() > 0 ? 15 : 0;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
        this.slotsUsed.clear();
        this.slotsUsed.addAll(Arrays.stream(cmp.func_74759_k("slotsUsed")).boxed().collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        cmp.func_197646_b("slotsUsed", this.slotsUsed);
        return super.func_189515_b(cmp);
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
        this.slotsUsed.clear();
        this.slotsUsed.addAll(Arrays.stream(cmp.func_74759_k("slotsUsed")).boxed().collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        cmp.func_197646_b("slotsUsed", this.slotsUsed);
        return cmp;
    }
}

