/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.World;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileMechanicalManaPool
extends BotanicalTile {
    public static final List<Item> CATALYSTS = Arrays.asList(ModBlocks.alchemyCatalyst.func_199767_j(), ModBlocks.conjurationCatalyst.func_199767_j(), ModBlocks.manaVoid.func_199767_j());
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(3, this::onSlotChanged, this::isValidStack);
    public boolean validRecipe = true;
    private int cooldown = LibXServerConfig.WorkingDurationMultiplier.mechanicalManaPool;

    public TileMechanicalManaPool(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.mechanicalManaPool);
        this.inventory.addSlotLimit(0, 1);
        this.inventory.setOutputSlots(new int[]{2});
    }

    public IManaInfusionRecipe getMatchingRecipe(@Nonnull ItemStack stack, @Nonnull ItemStack cat) {
        if (stack.func_190926_b()) {
            return null;
        }
        ArrayList<IManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<IManaInfusionRecipe>();
        ArrayList<IManaInfusionRecipe> matchingCatRecipes = new ArrayList<IManaInfusionRecipe>();
        for (IManaInfusionRecipe recipe : TilePool.manaInfusionRecipes((World)this.field_145850_b)) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (recipe.getCatalyst().func_177230_c().func_199767_j() != cat.func_77973_b()) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    private void onSlotChanged(int slot) {
        if (slot == 1) {
            ItemStack cat;
            ItemStack stack = this.getInventory().getStackInSlot(1);
            IManaInfusionRecipe recipe = this.getMatchingRecipe(stack, cat = this.getInventory().getStackInSlot(0));
            this.validRecipe = recipe != null ? recipe.getManaToConsume() <= this.getCurrentMana() : stack.func_190926_b();
        }
        this.markDispatchable();
        this.func_70296_d();
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (slot == 0) {
            return CATALYSTS.contains(stack.func_77973_b());
        }
        if (slot == 1) {
            return RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.MANA_INFUSION_TYPE, (ItemStack)stack);
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            ItemStack stack = this.getInventory().getStackInSlot(1);
            ItemStack cat = this.getInventory().getStackInSlot(0);
            IManaInfusionRecipe recipe = this.getMatchingRecipe(stack, cat);
            if (!this.field_145850_b.field_72995_K) {
                if (recipe != null) {
                    if (this.getCooldown() > 1) {
                        --this.cooldown;
                    } else {
                        int mana = recipe.getManaToConsume();
                        if (this.getCurrentMana() >= mana && (this.getInventory().getStackInSlot(2).func_190926_b() || recipe.func_77571_b().func_77973_b() == this.getInventory().getStackInSlot(2).func_77973_b() && this.getInventory().getStackInSlot(2).func_77976_d() > this.getInventory().getStackInSlot(2).func_190916_E())) {
                            this.receiveMana(-mana);
                            stack.func_190918_g(1);
                            ItemStack output = recipe.func_77571_b().func_77946_l();
                            this.inventory.getUnrestricted().insertItem(2, output, false);
                            this.func_70296_d();
                            this.cooldown = LibXServerConfig.WorkingDurationMultiplier.mechanicalManaPool;
                        }
                    }
                }
            } else if (LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory) {
                double particleChance = (double)this.getCurrentMana() / (double)this.getManaCap() * 0.1;
                if (Math.random() < particleChance) {
                    float red = 0.0f;
                    float green = 0.7764706f;
                    float blue = 1.0f;
                    WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)red, (float)green, (float)blue, (float)2.0f);
                    this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.5 + this.field_145850_b.field_73012_v.nextDouble() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, (double)(this.field_145850_b.field_73012_v.nextFloat() / 25.0f), 0.0);
                }
            }
        }
    }

    @Override
    public boolean hasValidRecipe() {
        return this.validRecipe;
    }

    @Override
    public void receiveMana(int i) {
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModBlocks.manaVoid.func_199767_j()) {
            super.receiveMana(Math.min(i, this.getAvailableSpaceForMana()));
        } else {
            super.receiveMana(i);
        }
    }

    @Override
    public boolean isFull() {
        return this.inventory.getStackInSlot(0).func_77973_b() != ModBlocks.manaVoid.func_199767_j() && super.isFull();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public int getComparatorOutput() {
        return !this.inventory.getStackInSlot(1).func_190926_b() ? 15 : 0;
    }
}

