/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.BlockManaBattery;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.tiles.TileMechanicalManaPool;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.item.ItemBlackLotus;
import vazkii.botania.common.item.ModItems;

public class TileManaBattery
extends BotanicalTile {
    public static final ResourceLocation SOLIDIFIED_MANA_ID = new ResourceLocation("mythicbotany", "solidified_mana");
    private static final int MANA_TRANSFER_RATE = 5000;
    private boolean slot1Locked;
    private boolean slot2Locked;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(2, slot -> {
        this.removePhantomItems();
        this.markDispatchable();
    }, this::isValidStack);

    public TileManaBattery(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.manaBattery);
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof IManaItem) {
            IManaItem item = (IManaItem)stack.func_77973_b();
            if (slot == 0 && (item.getMana(stack) >= item.getMaxMana(stack) || !item.canReceiveManaFromPool(stack, (TileEntity)this) || this.slot1Locked)) {
                return false;
            }
            if (slot == 1 && (item.getMana(stack) <= 0 || !item.canExportManaToPool(stack, (TileEntity)this) || this.slot2Locked)) {
                return false;
            }
        } else if (slot == 1 && stack.func_77973_b() instanceof ItemBlackLotus && !this.slot2Locked) {
            return true;
        }
        return stack.func_77973_b() instanceof IManaItem;
    }

    @Override
    public int getCurrentMana() {
        return ((BlockManaBattery)this.func_195044_w().func_177230_c()).variant == BlockManaBattery.Variant.CREATIVE ? this.getManaCap() / 2 : super.getCurrentMana();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int manaValue;
            int maxManaValue;
            IManaItem manaItem;
            ItemStack minus = this.inventory.getStackInSlot(0);
            ItemStack plus = this.inventory.getStackInSlot(1);
            if (!minus.func_190926_b() && minus.func_77973_b() instanceof IManaItem && (manaItem = (IManaItem)minus.func_77973_b()).canReceiveManaFromPool(minus, (TileEntity)this)) {
                maxManaValue = ((BlockManaBattery)this.func_195044_w().func_177230_c()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                manaValue = Math.min(maxManaValue, Math.min(this.getCurrentMana(), manaItem.getMaxMana(minus) - manaItem.getMana(minus)));
                manaItem.addMana(minus, manaValue);
                this.receiveMana(-manaValue);
                this.func_70296_d();
                this.markDispatchable();
                this.removePhantomItems();
            }
            if (!plus.func_190926_b()) {
                if (plus.func_77973_b() instanceof IManaItem) {
                    manaItem = (IManaItem)plus.func_77973_b();
                    if (manaItem.canExportManaToPool(plus, (TileEntity)this)) {
                        maxManaValue = ((BlockManaBattery)this.func_195044_w().func_177230_c()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                        manaValue = Math.min(maxManaValue, Math.min(this.getManaCap() - this.getCurrentMana(), manaItem.getMana(plus)));
                        manaItem.addMana(plus, -manaValue);
                        this.receiveMana(manaValue);
                        this.func_70296_d();
                        this.markDispatchable();
                        this.removePhantomItems();
                    }
                } else if (plus.func_77973_b() instanceof ItemBlackLotus) {
                    int receivingMana;
                    ItemBlackLotus item = (ItemBlackLotus)plus.func_77973_b();
                    int n = receivingMana = item == ModItems.blackerLotus ? 100000 : 8000;
                    if (this.getManaCap() - this.getCurrentMana() >= receivingMana) {
                        this.receiveMana(receivingMana);
                        this.inventory.extractItem(1, 1, false);
                        this.func_70296_d();
                        this.markDispatchable();
                    }
                }
            }
            for (Direction direction : Direction.values()) {
                BotanicalTile offsetTile;
                TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
                if (!(tile instanceof BotanicalTile) || (offsetTile = (BotanicalTile)tile).isFull()) continue;
                int maxManaValue2 = ((BlockManaBattery)this.func_195044_w().func_177230_c()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                int manaValue2 = Math.min(maxManaValue2, Math.min(this.getCurrentMana(), offsetTile.getManaCap() - offsetTile.getCurrentMana()));
                if (manaValue2 <= 0 && offsetTile instanceof TileMechanicalManaPool) {
                    manaValue2 = Math.min(this.getCurrentMana(), 5000);
                }
                this.receiveMana(-manaValue2);
                offsetTile.receiveMana(manaValue2);
                this.func_70296_d();
                this.markDispatchable();
            }
        }
    }

    public boolean isSlot1Locked() {
        return this.slot1Locked;
    }

    public boolean isSlot2Locked() {
        return this.slot2Locked;
    }

    public void setSlot1Locked(boolean slot1Locked) {
        if (slot1Locked != this.slot1Locked) {
            this.slot1Locked = slot1Locked;
            this.func_70296_d();
        }
    }

    public void setSlot2Locked(boolean slot2Locked) {
        if (slot2Locked != this.slot2Locked) {
            this.slot2Locked = slot2Locked;
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorOutput() {
        return (int)Math.round((double)this.getCurrentMana() / (double)this.getManaCap() * 15.0);
    }

    @Override
    protected LazyOptional<IItemHandlerModifiable> createCap(Supplier<IItemHandlerModifiable> inventory) {
        return ItemStackHandlerWrapper.createLazy(inventory, slot -> {
            ItemStack minus = ((IItemHandlerModifiable)inventory.get()).getStackInSlot(0);
            ItemStack plus = ((IItemHandlerModifiable)inventory.get()).getStackInSlot(1);
            if (slot == 0 && minus.func_77973_b() instanceof IManaItem) {
                IManaItem manaItem = (IManaItem)minus.func_77973_b();
                return manaItem.getMana(minus) >= manaItem.getMaxMana(minus);
            }
            if (slot == 1 && plus.func_77973_b() instanceof IManaItem) {
                IManaItem manaItem = (IManaItem)plus.func_77973_b();
                return manaItem.getMana(plus) <= 0 && !SOLIDIFIED_MANA_ID.equals((Object)plus.func_77973_b().getRegistryName());
            }
            return true;
        }, null);
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.slot1Locked = cmp.func_74767_n("slot1Locked");
        this.slot2Locked = cmp.func_74767_n("slot2Locked");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74757_a("slot1Locked", this.slot1Locked);
        cmp.func_74757_a("slot2Locked", this.slot2Locked);
        return super.func_189515_b(cmp);
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.slot1Locked = cmp.func_74767_n("slot1Locked");
        this.slot2Locked = cmp.func_74767_n("slot2Locked");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_74757_a("slot1Locked", this.slot1Locked);
        cmp.func_74757_a("slot2Locked", this.slot2Locked);
        return cmp;
    }

    private void removePhantomItems() {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (!SOLIDIFIED_MANA_ID.equals((Object)stack.func_77973_b().getRegistryName()) || !(stack.func_77973_b() instanceof IManaItem) || ((IManaItem)stack.func_77973_b()).getMana(stack) > 0) continue;
            this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }
}

