/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;

public class ItemThunderSword
extends ItemManasteelSword {
    private static final String TAG_LIGHTNING_SEED = "lightningSeed";

    public ItemThunderSword(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), 3, -1.5f, props);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity entity, @Nonnull LivingEntity attacker) {
        if (!(entity instanceof PlayerEntity) && entity != null) {
            double range = 8.0;
            ArrayList<LivingEntity> alreadyTargetedEntities = new ArrayList<LivingEntity>();
            int dmg = 5;
            long lightningSeed = ItemNBTHelper.getLong(stack, TAG_LIGHTNING_SEED, 0L);
            Predicate<Entity> selector = e -> e instanceof LivingEntity && e instanceof IMob && !(e instanceof PlayerEntity) && !alreadyTargetedEntities.contains(e);
            Random rand = new Random(lightningSeed);
            LivingEntity lightningSource = entity;
            int hops = entity.field_70170_p.func_72911_I() ? 10 : 4;
            for (int i = 0; i < hops; ++i) {
                List entities = entity.field_70170_p.func_175674_a((Entity)lightningSource, new AxisAlignedBB(lightningSource.func_226277_ct_() - range, lightningSource.func_226278_cu_() - range, lightningSource.func_226281_cx_() - range, lightningSource.func_226277_ct_() + range, lightningSource.func_226278_cu_() + range, lightningSource.func_226281_cx_() + range), selector::test);
                if (entities.isEmpty()) break;
                LivingEntity target = (LivingEntity)entities.get(rand.nextInt(entities.size()));
                if (attacker instanceof PlayerEntity) {
                    target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), (float)dmg);
                } else {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), (float)dmg);
                }
                Botania.proxy.lightningFX(Vector3.fromEntityCenter((Entity)lightningSource), Vector3.fromEntityCenter((Entity)target), 1.0f, 96708, 0xAADFFF);
                alreadyTargetedEntities.add(target);
                lightningSource = target;
                --dmg;
            }
            if (!entity.field_70170_p.field_72995_K) {
                ItemNBTHelper.setLong(stack, TAG_LIGHTNING_SEED, entity.field_70170_p.field_73012_v.nextLong());
            }
        }
        return super.func_77644_a(stack, entity, attacker);
    }
}

