/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityEnderAirBottle
extends ThrowableEntity
implements IRendersAsItem {
    private static final ResourceLocation GHAST_LOOT_TABLE = ResourceLocationHelper.prefix("ghast_ender_air_crying");

    public EntityEnderAirBottle(EntityType<EntityEnderAirBottle> type, World world) {
        super(type, world);
    }

    public EntityEnderAirBottle(LivingEntity entity, World world) {
        super(ModEntities.ENDER_AIR_BOTTLE, entity, world);
    }

    public EntityEnderAirBottle(double x, double y, double z, World world) {
        super(ModEntities.ENDER_AIR_BOTTLE, x, y, z, world);
    }

    private void convertStone(@Nonnull BlockPos pos) {
        List<BlockPos> coordsList = this.getCoordsToPut(pos);
        this.field_70170_p.func_217379_c(2002, this.func_233580_cy_(), 8);
        for (BlockPos coords : coordsList) {
            this.field_70170_p.func_175656_a(coords, Blocks.field_150377_bs.func_176223_P());
            if (!(Math.random() < 0.1)) continue;
            this.field_70170_p.func_217379_c(2001, coords, Block.func_196246_j((BlockState)Blocks.field_150377_bs.func_176223_P()));
        }
    }

    protected void func_230299_a_(@Nonnull BlockRayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.convertStone(result.func_216350_a());
        this.func_70106_y();
    }

    protected void func_213868_a(@Nonnull EntityRayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = result.func_216348_a();
        if (entity.func_200600_R() == EntityType.field_200811_y && this.field_70170_p.func_234923_W_() == World.field_234918_g_) {
            this.field_70170_p.func_217379_c(2002, this.func_233580_cy_(), 8);
            DamageSource source = DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_());
            entity.func_70097_a(source, 0.0f);
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d vec = new Vector3d(lookVec.func_82615_a(), 0.0, lookVec.func_82616_c()).func_72432_b();
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151073_bk)), entity.func_226277_ct_() + 2.3 * vec.field_72450_a, entity.func_226278_cu_() + vec.field_72448_b + 2.6, entity.func_226281_cx_() + 2.3 * vec.field_72449_c, 40, Math.abs(vec.field_72449_c) + 0.15, 0.2, Math.abs(vec.field_72450_a) + 0.15, 0.2);
            LootTable table = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(GHAST_LOOT_TABLE);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p);
            builder.func_216015_a(LootParameters.field_216281_a, (Object)entity);
            builder.func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch());
            builder.func_216015_a(LootParameters.field_216283_c, (Object)source);
            LootContext context = builder.func_216022_a(LootParameterSets.field_216263_d);
            for (ItemStack stack : table.func_216113_a(context)) {
                ItemEntity item = entity.func_70099_a(stack, 2.0f);
                item.func_213317_d(item.func_213322_ci().func_178787_e(vec.func_186678_a(0.4)));
            }
        } else {
            this.convertStone(new BlockPos(result.func_216347_e()));
        }
        this.func_70106_y();
    }

    private List<BlockPos> getCoordsToPut(BlockPos pos) {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = 4;
        int rangeY = 4;
        for (BlockPos bPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -rangeY, -range), (BlockPos)pos.func_177982_a(range, rangeY, range))) {
            BlockState state = this.field_70170_p.func_180495_p(bPos);
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            possibleCoords.add(bPos.func_185334_h());
        }
        Collections.shuffle(possibleCoords, this.field_70146_Z);
        return possibleCoords.stream().limit(64L).collect(Collectors.toList());
    }

    protected void func_70088_a() {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ModItems.enderAirBottle);
    }
}

