/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class RecipeElvenTrade
implements IElvenTradeRecipe {
    private final ResourceLocation id;
    private final ImmutableList<ItemStack> outputs;
    private final NonNullList<Ingredient> inputs;

    public RecipeElvenTrade(ResourceLocation id, ItemStack[] outputs, Ingredient ... inputs) {
        this.id = id;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                Ingredient ingr = (Ingredient)inputsMissing.get(i);
                if (!ingr.test(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        for (Ingredient input : this.inputs) {
            if (!input.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.ELVEN_TRADE_SERIALIZER;
    }

    @Override
    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.alfPortal);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        return this.getOutputs();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeElvenTrade> {
        @Nonnull
        public RecipeElvenTrade read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            JsonElement output = json.get("output");
            ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
            if (output.isJsonArray()) {
                for (JsonElement e : output.getAsJsonArray()) {
                    JsonObject o = JSONUtils.func_151210_l((JsonElement)e, (String)"output stack");
                    outputStacks.add(ShapedRecipe.func_199798_a((JsonObject)o));
                }
            } else {
                JsonObject o = JSONUtils.func_151210_l((JsonElement)output, (String)"output stack");
                outputStacks.add(ShapedRecipe.func_199798_a((JsonObject)o));
            }
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                Ingredient ing = Ingredient.func_199802_a((JsonElement)e);
                if (ing.func_203189_d()) continue;
                inputs.add(ing);
            }
            return new RecipeElvenTrade(id, outputStacks.toArray(new ItemStack[0]), inputs.toArray(new Ingredient[0]));
        }

        public RecipeElvenTrade read(@Nonnull ResourceLocation id, PacketBuffer buf) {
            Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
            }
            ItemStack[] outputs = new ItemStack[buf.func_150792_a()];
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = buf.func_150791_c();
            }
            return new RecipeElvenTrade(id, outputs, inputs);
        }

        public void write(PacketBuffer buf, RecipeElvenTrade recipe) {
            buf.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient input : recipe.func_192400_c()) {
                input.func_199564_a(buf);
            }
            buf.func_150787_b(recipe.getOutputs().size());
            for (ItemStack output : recipe.getOutputs()) {
                buf.writeItemStack(output, false);
            }
        }
    }
}

