/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.MathHelper;

public class SubTileVinculotus
extends TileEntityFunctionalFlower {
    public static final Set<SubTileVinculotus> existingFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final int RANGE = 64;

    public SubTileVinculotus() {
        super(ModSubtiles.VINCULOTUS);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.func_145831_w().field_72995_K) {
            existingFlowers.add(this);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 64.0);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 680017;
    }

    @Override
    public int getMaxMana() {
        return 500;
    }

    public static void onEndermanTeleport(EnderTeleportEvent event) {
        int cost = 50;
        if (event.getEntityLiving() instanceof EndermanEntity) {
            ArrayList<SubTileVinculotus> possibleFlowers = new ArrayList<SubTileVinculotus>();
            for (SubTileVinculotus flower : existingFlowers) {
                double z;
                double y;
                double x;
                BlockPos activePos = flower.getEffectivePos();
                if (flower.redstoneSignal > 0 || flower.getMana() <= cost || flower.func_145831_w() != event.getEntityLiving().field_70170_p || flower.func_145831_w().func_175625_s(flower.func_174877_v()) != flower || !(MathHelper.pointDistanceSpace(x = (double)activePos.func_177958_n() + 0.5, y = (double)activePos.func_177956_o() + 1.5, z = (double)activePos.func_177952_p() + 0.5, event.getTargetX(), event.getTargetY(), event.getTargetZ()) < 64.0f)) continue;
                possibleFlowers.add(flower);
            }
            if (!possibleFlowers.isEmpty()) {
                SubTileVinculotus flower = (SubTileVinculotus)possibleFlowers.get(event.getEntityLiving().field_70170_p.field_73012_v.nextInt(possibleFlowers.size()));
                BlockPos activePos = flower.getEffectivePos();
                double x = (double)activePos.func_177958_n() + 0.5;
                double y = (double)activePos.func_177956_o() + 1.5;
                double z = (double)activePos.func_177952_p() + 0.5;
                event.setTargetX(x + Math.random() * 3.0 - 1.0);
                event.setTargetY(y);
                event.setTargetZ(z + Math.random() * 3.0 - 1.0);
                flower.addMana(-cost);
                flower.sync();
            }
        }
    }
}

