/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.core.handler.RenderLexicon;
import vazkii.botania.client.model.GunModel;
import vazkii.botania.client.model.LexiconModel;
import vazkii.botania.client.model.PlatformModel;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.tile.RenderTileCorporeaCrystalCube;
import vazkii.botania.client.render.tile.RenderTilePump;
import vazkii.botania.common.Botania;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorItemOverrideList;
import vazkii.botania.mixin.AccessorModelBakery;

public class MiscellaneousIcons {
    public static final MiscellaneousIcons INSTANCE = new MiscellaneousIcons();
    public final RenderMaterial alfPortalTex = MiscellaneousIcons.mainAtlas("block/alfheim_portal_swirl");
    public final RenderMaterial lightRelayWorldIcon = MiscellaneousIcons.mainAtlas("block/light_relay");
    public final RenderMaterial lightRelayDetectorWorldIcon = MiscellaneousIcons.mainAtlas("block/detector_light_relay");
    public final RenderMaterial lightRelayForkWorldIcon = MiscellaneousIcons.mainAtlas("block/fork_light_relay");
    public final RenderMaterial lightRelayToggleWorldIcon = MiscellaneousIcons.mainAtlas("block/toggle_light_relay");
    public final RenderMaterial alchemyCatalystOverlay = MiscellaneousIcons.mainAtlas("block/alchemy_catalyst_overlay");
    public final RenderMaterial conjurationCatalystOverlay = MiscellaneousIcons.mainAtlas("block/conjuration_catalyst_overlay");
    public final RenderMaterial enchanterOverlay = MiscellaneousIcons.mainAtlas("block/enchanter_overlay");
    public final RenderMaterial manaVoidOverlay = MiscellaneousIcons.mainAtlas("block/mana_void_overlay");
    public final RenderMaterial manaWater = MiscellaneousIcons.mainAtlas("block/mana_water");
    public final RenderMaterial terraPlateOverlay = MiscellaneousIcons.mainAtlas("block/terra_plate_overlay");
    public final RenderMaterial corporeaWorldIcon = MiscellaneousIcons.mainAtlas("item/corporea_spark");
    public final RenderMaterial corporeaWorldIconMaster = MiscellaneousIcons.mainAtlas("item/corporea_spark_master");
    public final RenderMaterial corporeaIconStar = MiscellaneousIcons.mainAtlas("item/corporea_spark_star");
    public final RenderMaterial sparkWorldIcon = MiscellaneousIcons.mainAtlas("item/spark");
    public final RenderMaterial[] sparkUpgradeIcons = new RenderMaterial[]{MiscellaneousIcons.mainAtlas("item/spark_upgrade_rune_dispersive"), MiscellaneousIcons.mainAtlas("item/spark_upgrade_rune_dominant"), MiscellaneousIcons.mainAtlas("item/spark_upgrade_rune_recessive"), MiscellaneousIcons.mainAtlas("item/spark_upgrade_rune_isolated")};
    public final IBakedModel[] tiaraWingIcons = new IBakedModel[9];
    public final IBakedModel[] thirdEyeLayers = new IBakedModel[3];
    public IBakedModel goldfishModel;
    public IBakedModel phiFlowerModel;
    public IBakedModel nerfBatModel;
    public IBakedModel bloodPendantChain;
    public IBakedModel bloodPendantGem;
    public IBakedModel snowflakePendantGem;
    public IBakedModel itemFinderGem;
    public IBakedModel pyroclastGem;
    public IBakedModel crimsonGem;
    public IBakedModel cirrusGem;
    public IBakedModel nimbusGem;
    public IBakedModel terrasteelHelmWillModel;
    public IBakedModel elvenSpreaderInside;
    public IBakedModel gaiaSpreaderInside;
    public IBakedModel manaSpreaderInside;
    public IBakedModel redstoneSpreaderInside;
    public final IBakedModel[] kingKeyWeaponModels = new IBakedModel[12];

    public void onModelRegister(ModelRegistryEvent evt) {
        int i;
        Set<RenderMaterial> materials = AccessorModelBakery.getMaterials();
        materials.addAll(Arrays.asList(this.alfPortalTex, this.lightRelayWorldIcon, this.lightRelayDetectorWorldIcon, this.lightRelayForkWorldIcon, this.lightRelayToggleWorldIcon, this.alchemyCatalystOverlay, this.conjurationCatalystOverlay, this.enchanterOverlay, this.manaVoidOverlay, this.manaWater, this.terraPlateOverlay, this.corporeaWorldIcon, this.corporeaWorldIconMaster, this.corporeaIconStar, this.sparkWorldIcon));
        materials.addAll(Arrays.asList(this.sparkUpgradeIcons));
        materials.add(RenderLexicon.TEXTURE);
        materials.add(RenderLexicon.ELVEN_TEXTURE);
        for (BannerPattern pattern : BannerPattern.values()) {
            if (!pattern.func_190997_a().startsWith("botania")) continue;
            materials.add(new RenderMaterial(Atlases.field_228745_d_, pattern.func_226957_a_(false)));
            materials.add(new RenderMaterial(Atlases.field_228744_c_, pattern.func_226957_a_(true)));
        }
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/goldfish"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/phiflower"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/nerfbat"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    public void onModelBake(ModelBakeEvent evt) {
        int i;
        if (!ModelHandler.registeredModels) {
            Botania.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        ModelResourceLocation abstruseName = new ModelResourceLocation("botania:abstruse_platform", "");
        IBakedModel abstruse = (IBakedModel)evt.getModelRegistry().get(abstruseName);
        ModelResourceLocation spectralName = new ModelResourceLocation("botania:spectral_platform", "");
        IBakedModel spectral = (IBakedModel)evt.getModelRegistry().get(spectralName);
        ModelResourceLocation infrangibleName = new ModelResourceLocation("botania:infrangible_platform", "");
        IBakedModel infrangible = (IBakedModel)evt.getModelRegistry().get(infrangibleName);
        evt.getModelRegistry().put(abstruseName, new PlatformModel(abstruse));
        evt.getModelRegistry().put(spectralName, new PlatformModel(spectral));
        evt.getModelRegistry().put(infrangibleName, new PlatformModel(infrangible));
        IBakedModel original = (IBakedModel)evt.getModelRegistry().get(new ModelResourceLocation("botania:lexicon", "inventory"));
        evt.getModelRegistry().put(new ModelResourceLocation("botania:lexicon", "inventory"), new LexiconModel(original));
        List<IBakedModel> overrides = ((AccessorItemOverrideList)original.func_188617_f()).getOverrideBakedModels();
        for (int i2 = 0; i2 < overrides.size(); ++i2) {
            overrides.set(i2, new LexiconModel(overrides.get(i2)));
        }
        ModelResourceLocation key = new ModelResourceLocation("botania:mana_gun", "inventory");
        IBakedModel originalModel = (IBakedModel)evt.getModelRegistry().get(key);
        ModelResourceLocation clipKey = new ModelResourceLocation("botania:mana_gun_clip", "inventory");
        IBakedModel originalModelClip = (IBakedModel)evt.getModelRegistry().get(clipKey);
        evt.getModelRegistry().put(key, new GunModel((ModelBakery)evt.getModelLoader(), originalModel, originalModelClip));
        ModelResourceLocation tinyPotato = new ModelResourceLocation("botania:tiny_potato", "inventory");
        IBakedModel originalPotato = (IBakedModel)evt.getModelRegistry().get(tinyPotato);
        evt.getModelRegistry().put(tinyPotato, new TinyPotatoModel(originalPotato));
        RenderTileCorporeaCrystalCube.cubeModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        RenderTilePump.headModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/pump_head"));
        this.elvenSpreaderInside = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/elven_spreader_inside"));
        this.gaiaSpreaderInside = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/gaia_spreader_inside"));
        this.manaSpreaderInside = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/mana_spreader_inside"));
        this.redstoneSpreaderInside = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/redstone_spreader_inside"));
        this.goldfishModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/goldfish"));
        this.phiFlowerModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/phiflower"));
        this.nerfBatModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/nerfbat"));
        this.bloodPendantChain = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        this.bloodPendantGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponModels[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        this.terrasteelHelmWillModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            this.thirdEyeLayers[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        this.pyroclastGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        this.crimsonGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        this.itemFinderGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        this.cirrusGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        this.nimbusGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        this.snowflakePendantGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            this.tiaraWingIcons[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    private static RenderMaterial mainAtlas(String name) {
        return new RenderMaterial(AtlasTexture.field_110575_b, ResourceLocationHelper.prefix(name));
    }

    private MiscellaneousIcons() {
    }
}

