/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.material.ItemSelfReturning;

public class ItemRainbowRod
extends ItemSelfReturning
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_rainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 4;
    private static final int TIME = 600;

    public ItemRainbowRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false)) {
            BlockState bifrost = ModBlocks.bifrost.func_176223_P();
            Vector3 vector = new Vector3(player.func_70040_Z()).normalize();
            double x = player.func_226277_ct_();
            double y = player.func_226278_cu_() - 1.0;
            double z = player.func_226281_cx_();
            BlockPos.Mutable pos = new BlockPos.Mutable((int)x, (int)y, (int)z);
            double lastX = 0.0;
            double lastY = -1.0;
            double lastZ = 0.0;
            BlockPos.Mutable previousPos = new BlockPos.Mutable();
            boolean placedAny = false;
            boolean prof = IManaProficiencyArmor.hasProficiency(player, stack);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            BlockPos.Mutable placePos = new BlockPos.Mutable();
            for (int count = 0; count < maxlen; ++count) {
                previousPos.func_189532_c(lastX, lastY, lastZ);
                if (!previousPos.equals((Object)pos)) {
                    if (!world.func_175623_d((BlockPos)pos) && world.func_180495_p((BlockPos)pos) != bifrost && count >= 4 || World.func_217405_b((int)pos.func_177956_o())) break;
                    if (ItemRainbowRod.placeBridgeSegment(world, (BlockPos)pos, placePos, time)) {
                        placedAny = true;
                    }
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                pos.func_189532_c(x += vector.x, y += vector.y, z += vector.z);
            }
            if (placedAny) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.bifrostRod, SoundCategory.PLAYERS, 0.5f, 0.25f);
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, true);
                player.func_184811_cZ().func_185145_a((Item)this, player.func_184812_l_() ? 10 : 600);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    private static boolean placeBridgeSegment(World world, BlockPos center, BlockPos.Mutable placePos, int time) {
        BlockState bifrost = ModBlocks.bifrost.func_176223_P();
        boolean placed = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                placePos.func_181079_c(center.func_177958_n() + i, center.func_177956_o(), center.func_177952_p() + j);
                if (!world.func_175623_d((BlockPos)placePos) && world.func_180495_p((BlockPos)placePos) != bifrost) continue;
                world.func_180501_a((BlockPos)placePos, bifrost, 2);
                TileBifrost tile = (TileBifrost)world.func_175625_s((BlockPos)placePos);
                if (tile == null) continue;
                tile.ticks = time;
                placed = true;
            }
        }
        return placed;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = tile.tileEntity();
        World world = te.func_145831_w();
        if (world.field_72995_K || tile.getCurrentMana() < 100 || !tile.isEnabled() || World.func_217405_b((int)(te.func_174877_v().func_177956_o() - 1))) {
            return;
        }
        BlockPos tePos = te.func_174877_v();
        int w = 1;
        int h = 1;
        int l = 20;
        AxisAlignedBB axis = null;
        switch ((Direction)world.func_180495_p(tePos).func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            case NORTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, -l), tePos.func_177982_a(w + 1, h, 0));
                break;
            }
            case SOUTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, 1), tePos.func_177982_a(w + 1, h, l + 1));
                break;
            }
            case WEST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-l, -h, -w), tePos.func_177982_a(0, h, w + 1));
                break;
            }
            case EAST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(1, -h, -w), tePos.func_177982_a(l + 1, h, w + 1));
                break;
            }
        }
        List players = world.func_217357_a(PlayerEntity.class, axis);
        for (PlayerEntity p : players) {
            int px = MathHelper.func_76128_c((double)p.func_226277_ct_());
            int py = MathHelper.func_76128_c((double)p.func_226278_cu_()) - 1;
            int pz = MathHelper.func_76128_c((double)p.func_226281_cx_());
            int dist = 5;
            int diff = dist / 2;
            for (int i = 0; i < dist; ++i) {
                for (int j = 0; j < dist; ++j) {
                    TileBifrost tileBifrost;
                    int ex = px + i - diff;
                    int ez = pz + j - diff;
                    if (!axis.func_72318_a(new Vector3d((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                    BlockPos pos = new BlockPos(ex, py, ez);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block.isAir(world.func_180495_p(pos), (IBlockReader)world, pos)) {
                        if (!world.func_175656_a(pos, ModBlocks.bifrost.func_176223_P())) continue;
                        tileBifrost = (TileBifrost)world.func_175625_s(pos);
                        tileBifrost.ticks = 10;
                        tile.receiveMana(-4);
                        continue;
                    }
                    if (block != ModBlocks.bifrost) continue;
                    tileBifrost = (TileBifrost)world.func_175625_s(pos);
                    if (tileBifrost.ticks >= 2) continue;
                    tileBifrost.ticks += 10;
                    tile.receiveMana(-4);
                }
            }
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

