/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.StringObfuscator;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemFlightTiara
extends ItemBauble
implements IManaUsingItem {
    private static final ResourceLocation textureHud = new ResourceLocation("botania:textures/gui/hud_icons.png");
    public static final ResourceLocation textureHalo = new ResourceLocation("botania:textures/misc/halo.png");
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_FLYING = "flying";
    private static final String TAG_GLIDING = "gliding";
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_INFINITE_FLIGHT = "infiniteFlight";
    private static final String TAG_DASH_COOLDOWN = "dashCooldown";
    private static final String TAG_IS_SPRINTING = "isSprinting";
    private static final String TAG_BOOST_PENDING = "boostPending";
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());
    private static final int COST = 35;
    private static final int COST_OVERKILL = 105;
    private static final int MAX_FLY_TIME = 1200;
    private static final int SUBTYPES = 8;
    public static final int WING_TYPES = 9;
    private static final String SUPER_AWESOME_HASH = "4D0F274C5E3001C95640B5E88A821422C8B1E132264492C043A3D746B705C025";

    public ItemFlightTiara(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::updatePlayerFlyStatus);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedOut);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemNBTHelper.setInt(stack, TAG_VARIANT, i);
                list.add((Object)stack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        tooltip.add((ITextComponent)new TranslationTextComponent("botania.wings" + ItemFlightTiara.getVariant(stack)).func_240699_a_(TextFormatting.GRAY));
    }

    private void updatePlayerFlyStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)player);
            int left = ItemNBTHelper.getInt(tiara, TAG_TIME_LEFT, 1200);
            if (playersWithFlight.contains(ItemFlightTiara.playerStr(player))) {
                if (this.shouldPlayerHaveFlight(player)) {
                    player.field_71075_bZ.field_75101_c = true;
                    if (player.field_71075_bZ.field_75100_b) {
                        if (!player.field_70170_p.field_72995_K) {
                            if (!player.func_184812_l_() && !player.func_175149_v()) {
                                ManaItemHandler.instance().requestManaExact(tiara, player, this.getCost(tiara, left), true);
                            }
                        } else if (Math.abs(player.func_213322_ci().func_82615_a()) > 0.1 || Math.abs(player.func_213322_ci().func_82616_c()) > 0.1) {
                            double x = event.getEntityLiving().func_226277_ct_() - 0.5;
                            double y = event.getEntityLiving().func_226278_cu_() - 0.5;
                            double z = event.getEntityLiving().func_226281_cx_() - 0.5;
                            float r = 1.0f;
                            float g = 1.0f;
                            float b = 1.0f;
                            int variant = ItemFlightTiara.getVariant(tiara);
                            switch (variant) {
                                case 2: {
                                    r = 0.1f;
                                    g = 0.1f;
                                    b = 0.1f;
                                    break;
                                }
                                case 3: {
                                    r = 0.0f;
                                    g = 0.6f;
                                    break;
                                }
                                case 4: {
                                    g = 0.3f;
                                    b = 0.3f;
                                    break;
                                }
                                case 5: {
                                    r = 0.6f;
                                    g = 0.0f;
                                    b = 0.6f;
                                    break;
                                }
                                case 6: {
                                    r = 0.4f;
                                    g = 0.0f;
                                    b = 0.0f;
                                    break;
                                }
                                case 7: {
                                    r = 0.2f;
                                    g = 0.6f;
                                    b = 0.2f;
                                    break;
                                }
                                case 8: {
                                    r = 0.85f;
                                    g = 0.85f;
                                    b = 0.0f;
                                    break;
                                }
                                case 9: {
                                    r = 0.0f;
                                    b = 0.0f;
                                }
                            }
                            for (int i = 0; i < 2; ++i) {
                                SparkleParticleData data = SparkleParticleData.sparkle(2.0f * (float)Math.random(), r, g, b, 20);
                                player.field_70170_p.func_195594_a((IParticleData)data, x + Math.random() * (double)event.getEntityLiving().func_213311_cf(), y + Math.random() * 0.4, z + Math.random() * (double)event.getEntityLiving().func_213311_cf(), 0.0, 0.0, 0.0);
                            }
                        }
                    }
                } else {
                    if (!player.func_175149_v() && !player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75102_a = false;
                    }
                    playersWithFlight.remove(ItemFlightTiara.playerStr(player));
                }
            } else if (this.shouldPlayerHaveFlight(player)) {
                playersWithFlight.add(ItemFlightTiara.playerStr(player));
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().func_146103_bH().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static String playerStr(PlayerEntity player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    private boolean shouldPlayerHaveFlight(PlayerEntity player) {
        ItemStack armor = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)player);
        if (!armor.func_190926_b()) {
            int left = ItemNBTHelper.getInt(armor, TAG_TIME_LEFT, 1200);
            boolean flying = ItemNBTHelper.getBoolean(armor, TAG_FLYING, false);
            return (left > (flying ? 0 : 120) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.flugelEye))) && ManaItemHandler.instance().requestManaExact(armor, player, this.getCost(armor, left), false);
        }
        return false;
    }

    public int getCost(ItemStack stack, int timeLeft) {
        return timeLeft <= 0 ? 105 : 35;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack stack, LivingEntity living) {
        super.onEquipped(stack, living);
        int variant = ItemFlightTiara.getVariant(stack);
        if (variant != 9 && StringObfuscator.matchesHash(stack.func_200301_q().getString(), SUPER_AWESOME_HASH)) {
            ItemNBTHelper.setInt(stack, TAG_VARIANT, 9);
            stack.func_135074_t();
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        if (player instanceof PlayerEntity) {
            int time;
            PlayerEntity p = (PlayerEntity)player;
            boolean flying = p.field_71075_bZ.field_75100_b;
            boolean wasSprting = ItemNBTHelper.getBoolean(stack, TAG_IS_SPRINTING, false);
            boolean isSprinting = p.func_70051_ag();
            if (isSprinting != wasSprting) {
                ItemNBTHelper.setBoolean(stack, TAG_IS_SPRINTING, isSprinting);
            }
            int newTime = time = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
            Vector3 look = new Vector3(p.func_70040_Z()).multiply(1.0, 0.0, 1.0).normalize();
            if (flying) {
                if (!(time <= 0 || p.func_175149_v() || p.func_184812_l_() || ItemNBTHelper.getBoolean(stack, TAG_INFINITE_FLIGHT, false))) {
                    --newTime;
                }
                int maxCd = 80;
                int cooldown = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
                if (!wasSprting && isSprinting && cooldown == 0) {
                    p.func_213317_d(p.func_213322_ci().func_72441_c(look.x, 0.0, look.z));
                    p.field_70170_p.func_184148_a(null, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), ModSounds.dash, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, 80);
                    ItemNBTHelper.setBoolean(stack, TAG_BOOST_PENDING, true);
                } else if (cooldown > 0) {
                    if (ItemNBTHelper.getBoolean(stack, TAG_BOOST_PENDING, false)) {
                        player.func_213309_a(5.0f, new Vector3d(0.0, 0.0, 1.0));
                        ItemNBTHelper.removeEntry(stack, TAG_BOOST_PENDING);
                    }
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, cooldown - 2);
                }
            } else {
                boolean doGlide;
                boolean wasGliding = ItemNBTHelper.getBoolean(stack, TAG_GLIDING, false);
                boolean bl = doGlide = player.func_225608_bj_() && !player.func_233570_aj_() && (player.func_213322_ci().func_82617_b() < (double)-0.7f || wasGliding);
                if (time < 1200 && player.field_70173_aa % (doGlide ? 6 : 2) == 0) {
                    ++newTime;
                }
                if (doGlide) {
                    float mul = 0.6f;
                    player.func_213293_j(look.x * (double)mul, Math.max((double)-0.15f, player.func_213322_ci().func_82617_b()), look.z * (double)mul);
                    player.field_70143_R = 2.0f;
                }
                ItemNBTHelper.setBoolean(stack, TAG_GLIDING, doGlide);
            }
            ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
            if (newTime != time) {
                ItemNBTHelper.setInt(stack, TAG_TIME_LEFT, newTime);
            }
        }
    }

    @Override
    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return super.hasRender(stack, living) && living instanceof PlayerEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderBasic(BipedModel<?> bipedModel, IBakedModel model, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, int light, float flap) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(0.0, 0.5, 0.2);
        for (int i = 0; i < 2; ++i) {
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(i == 0 ? flap : 180.0f - flap));
            ms.func_227861_a_(-1.0, 0.0, 0.0);
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-60.0f));
            ms.func_227862_a_(1.5f, -1.5f, -1.5f);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, ms, buffers, light, OverlayTexture.field_229196_a_, model);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderSephiroth(BipedModel<?> bipedModel, IBakedModel model, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, int light, float flap) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(0.0, 0.5, 0.2);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flap));
        ms.func_227861_a_(-1.1, 0.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-60.0f));
        ms.func_227862_a_(1.6f, -1.6f, -1.6f);
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, ms, buffers, light, OverlayTexture.field_229196_a_, model);
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderCirno(BipedModel<?> bipedModel, IBakedModel model, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(-0.8, 0.15, 0.25);
        for (int i = 0; i < 2; ++i) {
            ms.func_227860_a_();
            if (i == 1) {
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                ms.func_227861_a_(-1.6, 0.0, 0.0);
            }
            ms.func_227862_a_(1.6f, -1.6f, -1.6f);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, ms, buffers, light, OverlayTexture.field_229196_a_, model);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderPhoenix(BipedModel<?> bipedModel, IBakedModel model, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, float flap) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(0.0, -0.2, 0.2);
        for (int i = 0; i < 2; ++i) {
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(i == 0 ? flap : 180.0f - flap));
            ms.func_227861_a_(-0.9, 0.0, 0.0);
            ms.func_227862_a_(1.7f, -1.7f, -1.7f);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, ms, buffers, 0xF000F0, OverlayTexture.field_229196_a_, model);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderKuroyukihime(BipedModel<?> bipedModel, IBakedModel model, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, float flap) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(0.0, -0.4, 0.2);
        for (int i = 0; i < 2; ++i) {
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(i == 0 ? flap : 180.0f - flap));
            ms.func_227861_a_(-1.3, 0.0, 0.0);
            ms.func_227862_a_(2.5f, -2.5f, -2.5f);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, ms, buffers, 0xF000F0, OverlayTexture.field_229196_a_, model);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderCustomColor(BipedModel<?> bipedModel, IBakedModel model, LivingEntity living, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, float flap, int color) {
        ms.func_227860_a_();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(0.0, 0.0, 0.2);
        for (int i = 0; i < 2; ++i) {
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(i == 0 ? flap : 180.0f - flap));
            ms.func_227861_a_(-0.7, 0.0, 0.0);
            ms.func_227862_a_(1.5f, -1.5f, -1.5f);
            RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, 0xF000F0, OverlayTexture.field_229196_a_, model);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BipedModel<?> bipedModel, ItemStack stack, LivingEntity living, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int meta = ItemFlightTiara.getVariant(stack);
        if (meta <= 0 || meta >= MiscellaneousIcons.INSTANCE.tiaraWingIcons.length + 1) {
            return;
        }
        IBakedModel model = MiscellaneousIcons.INSTANCE.tiaraWingIcons[meta - 1];
        boolean flying = living instanceof PlayerEntity && ((PlayerEntity)living).field_71075_bZ.field_75100_b;
        float flap = 20.0f + (float)((Math.sin((double)((float)living.field_70173_aa + partialTicks) * (double)(flying ? 0.4f : 0.2f)) + 0.5) * (double)(flying ? 30.0f : 5.0f));
        switch (meta) {
            case 1: {
                ItemFlightTiara.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                ms.func_227860_a_();
                ItemFlightTiara.renderHalo(bipedModel, living, ms, buffers, partialTicks);
                ms.func_227865_b_();
                break;
            }
            case 2: {
                ItemFlightTiara.renderSephiroth(bipedModel, model, stack, ms, buffers, light, flap);
                break;
            }
            case 3: {
                ItemFlightTiara.renderCirno(bipedModel, model, stack, ms, buffers, light);
                break;
            }
            case 4: {
                ItemFlightTiara.renderPhoenix(bipedModel, model, stack, ms, buffers, flap);
                break;
            }
            case 5: {
                ItemFlightTiara.renderKuroyukihime(bipedModel, model, stack, ms, buffers, flap);
                break;
            }
            case 6: 
            case 8: {
                ItemFlightTiara.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                break;
            }
            case 7: {
                float alpha = 0.5f + (float)Math.cos((double)((float)living.field_70173_aa + partialTicks) * (double)0.3f) * 0.2f;
                int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                ItemFlightTiara.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
                break;
            }
            case 9: {
                flap = -((float)((Math.sin((double)((float)living.field_70173_aa + partialTicks) * (double)0.2f) + (double)0.6f) * (double)(flying ? 12.0f : 5.0f)));
                float alpha = 0.5f + (flying ? (float)Math.cos((double)((float)living.field_70173_aa + partialTicks) * (double)0.3f) * 0.25f + 0.25f : 0.0f);
                int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                ItemFlightTiara.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHalo(@Nullable BipedModel<?> model, @Nullable LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, float partialTicks) {
        if (model != null) {
            model.field_78116_c.func_228307_a_(ms);
        }
        ms.func_227861_a_(0.2, -0.65, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(30.0f));
        if (player != null) {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)player.field_70173_aa + partialTicks));
        } else {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ClientTickHandler.ticksInGame));
        }
        ms.func_227862_a_(0.75f, -0.75f, -0.75f);
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.HALO);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, -1.0f, 0.0f, -1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(mat, 1.0f, 0.0f, -1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(mat, 1.0f, 0.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, -1.0f, 0.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(MatrixStack ms, PlayerEntity player, ItemStack stack) {
        int xo;
        int u = Math.max(1, ItemFlightTiara.getVariant(stack)) * 9 - 9;
        int v = 0;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(textureHud);
        int x = xo = mc.func_228018_at_().func_198107_o() / 2 + 10;
        int y = mc.func_228018_at_().func_198087_p() - ForgeIngameGui.right_height;
        ForgeIngameGui.right_height += 10;
        int left = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
        int segTime = 120;
        int segs = left / segTime + 1;
        int last = left % segTime;
        for (int i = 0; i < segs; ++i) {
            float trans = 1.0f;
            if (i == segs - 1) {
                trans = (float)last / (float)segTime;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.disableAlphaTest();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 9, 9);
            x += 8;
        }
        if (player.field_71075_bZ.field_75100_b) {
            int width = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                AbstractGui.func_238467_a_((MatrixStack)ms, (int)xo, (int)(y - 2), (int)(xo + 80), (int)(y - 1), (int)-2013265920);
            }
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(AbstractGui.field_230665_h_);
    }

    public static int getVariant(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_VARIANT, 0);
    }
}

