/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;

public class ContributorList {
    private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.builder().put((Object)"daybloom", (Object)"daybloom_motif").put((Object)"nightshade", (Object)"nightshade_motif").put((Object)"puredaisy", (Object)LibBlockNames.SUBTILE_PUREDAISY.func_110623_a()).put((Object)"fallenkanade", (Object)LibBlockNames.SUBTILE_FALLEN_KANADE.func_110623_a()).put((Object)"heiseidream", (Object)LibBlockNames.SUBTILE_HEISEI_DREAM.func_110623_a()).put((Object)"arcanerose", (Object)LibBlockNames.SUBTILE_ARCANE_ROSE.func_110623_a()).put((Object)"jadedamaranthus", (Object)LibBlockNames.SUBTILE_JADED_AMARANTHUS.func_110623_a()).put((Object)"orechidignem", (Object)LibBlockNames.SUBTILE_ORECHID_IGNEM.func_110623_a()).build();
    private static volatile Map<String, ItemStack> flowerMap = Collections.emptyMap();
    private static boolean startedLoading = false;
    public static final String TAG_HEADFLOWER = "botania:headflower";

    public static void firstStart() {
        if (!startedLoading) {
            Thread thread = new Thread(ContributorList::fetch);
            thread.setName("Botania Contributor Fanciness Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(Botania.LOGGER));
            thread.start();
            startedLoading = true;
        }
    }

    public static ItemStack getFlower(String name) {
        return flowerMap.getOrDefault(name, ItemStack.field_190927_a);
    }

    public static boolean hasFlower(String name) {
        return flowerMap.containsKey(name);
    }

    private static void load(Properties props) {
        HashMap<String, ItemStack> m = new HashMap<String, ItemStack>();
        HashMap<Item, ItemStack> cachedStacks = new HashMap<Item, ItemStack>();
        for (String key : props.stringPropertyNames()) {
            ItemStack stack;
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                stack = cachedStacks.computeIfAbsent(ModBlocks.getFlower(DyeColor.func_196056_a((int)i)).func_199767_j(), ContributorList::configureStack);
            }
            catch (NumberFormatException e) {
                String rawName = value.toLowerCase(Locale.ROOT);
                String flowerName = (String)LEGACY_FLOWER_NAMES.getOrDefault((Object)rawName, (Object)rawName);
                Item item = ModTags.Items.CONTRIBUTOR_HEADFLOWERS.func_230236_b_().stream().filter(flower -> Registry.field_212630_s.func_177774_c(flower).func_110623_a().equals(flowerName)).findFirst().orElse(Items.field_221620_aV);
                stack = cachedStacks.computeIfAbsent(item, ContributorList::configureStack);
            }
            m.put(key, stack);
        }
        flowerMap = m;
    }

    private static ItemStack configureStack(Item item) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
        ench.put(Enchantments.field_185307_s, 1);
        Registry.field_212628_q.func_241873_b(new ResourceLocation("charm", "tinted")).ifPresent(e -> ench.put((Enchantment)e, 1));
        EnchantmentHelper.func_82782_a(ench, (ItemStack)stack);
        stack.func_77978_p().func_74757_a(TAG_HEADFLOWER, true);
        stack.func_77978_p().func_74778_a("charm_glint", DyeColor.YELLOW.func_176610_l());
        return stack;
    }

    private static void fetch() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
            Properties props = new Properties();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                props.load(reader);
                ContributorList.load(props);
            }
        }
        catch (IOException e) {
            Botania.LOGGER.info("Could not load contributors list. Either you're offline or GitHub is down. Nothing to worry about, carry on~");
        }
    }
}

