/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.TileRuneAltar;

public class RenderTileRuneAltar
extends TileEntityRenderer<TileRuneAltar> {
    private final ModelRenderer spinningCube = new ModelRenderer(64, 32, 42, 0);

    public RenderTileRuneAltar(TileEntityRendererDispatcher manager) {
        super(manager);
        this.spinningCube.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.spinningCube.func_78793_a(0.0f, 0.0f, 0.0f);
        this.spinningCube.func_78787_b(64, 64);
    }

    public void render(@Nonnull TileRuneAltar altar, float partticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        float scale;
        ms.func_227860_a_();
        int items = 0;
        for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().func_70301_a(i).func_190926_b(); ++i) {
            ++items;
        }
        float[] angles = new float[altar.inventorySize()];
        float anglePer = 360.0f / (float)items;
        float totalAngle = 0.0f;
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = totalAngle += anglePer;
        }
        double time = (float)ClientTickHandler.ticksInGame + partticks;
        for (int i = 0; i < altar.inventorySize(); ++i) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.5, 1.25, 0.5);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angles[i] + (float)time));
            ms.func_227861_a_(1.125, 0.0, 0.25);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            ms.func_227861_a_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
            ItemStack stack = altar.getItemHandler().func_70301_a(i);
            Minecraft mc = Minecraft.func_71410_x();
            if (!stack.func_190926_b()) {
                mc.func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffers);
            }
            ms.func_227865_b_();
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        this.renderSpinningCubes(ms, buffers, overlay, 2, 15);
        ms.func_227865_b_();
        ms.func_227861_a_(0.0, (double)0.2f, 0.0);
        float f = scale = altar.getTargetMana() == 0 ? 0.0f : (float)altar.getCurrentMana() / (float)altar.getTargetMana() / 75.0f;
        if (scale != 0.0f) {
            int seed = altar.func_174877_v().func_177958_n() ^ altar.func_174877_v().func_177956_o() ^ altar.func_174877_v().func_177952_p();
            ms.func_227861_a_(0.5, (double)0.7f, 0.5);
            RenderHelper.renderStar(ms, buffers, 58583, scale, scale, scale, seed);
        }
        ms.func_227865_b_();
    }

    private void renderSpinningCubes(MatrixStack ms, IRenderTypeBuffer buffers, int overlay, int cubes, int iters) {
        for (int curIter = iters; curIter > 0; --curIter) {
            float modifier = 6.0f;
            float rotationModifier = 0.2f;
            float radiusBase = 0.35f;
            float radiusMod = 0.05f;
            double ticks = (double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) - 1.3 * (double)(iters - curIter);
            float offsetPerCube = 360 / cubes;
            ms.func_227860_a_();
            ms.func_227861_a_((double)-0.025f, (double)0.85f, (double)-0.025f);
            for (int i = 0; i < cubes; ++i) {
                float offset = offsetPerCube * (float)i;
                float deg = (int)(ticks / (double)0.2f % 360.0 + (double)offset);
                float rad = deg * (float)Math.PI / 180.0f;
                float radiusX = (float)((double)0.35f + (double)0.05f * Math.sin(ticks / 6.0));
                float radiusZ = (float)((double)0.35f + (double)0.05f * Math.cos(ticks / 6.0));
                float x = (float)((double)radiusX * Math.cos(rad));
                float z = (float)((double)radiusZ * Math.sin(rad));
                float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                ms.func_227860_a_();
                ms.func_227861_a_((double)x, (double)y, (double)z);
                float xRotate = (float)Math.sin(ticks * (double)0.2f) / 2.0f;
                float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                float zRotate = (float)Math.cos(ticks * (double)0.2f) / 2.0f;
                ms.func_227863_a_(new Vector3f(xRotate, yRotate, zRotate).func_229187_a_(deg));
                float alpha = 1.0f;
                if (curIter < iters) {
                    alpha = (float)curIter / (float)iters * 0.4f;
                }
                IVertexBuilder buffer = buffers.getBuffer(curIter < iters ? RenderHelper.SPINNING_CUBE_GHOST : RenderHelper.SPINNING_CUBE);
                this.spinningCube.func_228309_a_(ms, buffer, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, alpha);
                ms.func_227865_b_();
            }
            ms.func_227865_b_();
        }
    }
}

