/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

public class RenderTileRedString
extends TileEntityRenderer<TileRedString> {
    private static int transparency = 0;

    public static void tick() {
        boolean hasWand;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean bl = hasWand = player != null && PlayerHelper.hasHeldItem((PlayerEntity)player, ModItems.twigWand);
        if (transparency > 0 && !hasWand) {
            --transparency;
        } else if (transparency < 10 && hasWand) {
            ++transparency;
        }
    }

    public RenderTileRedString(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(TileRedString tile, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        if (transparency <= 0) {
            return;
        }
        float sizeAlpha = (float)transparency / 10.0f;
        int color = 0xFF0000 | (int)(sizeAlpha * 255.0f) << 24;
        Direction dir = tile.getOrientation();
        BlockPos bind = tile.getBinding();
        if (bind != null) {
            Vector3 vecMag;
            ms.func_227860_a_();
            ms.func_227861_a_(0.5, 0.5, 0.5);
            Vector3 vecOrig = new Vector3(bind.func_177958_n() - tile.func_174877_v().func_177958_n(), bind.func_177956_o() - tile.func_174877_v().func_177956_o(), bind.func_177952_p() - tile.func_174877_v().func_177952_p());
            Vector3 vecNorm = vecOrig.normalize();
            Vector3 vecApply = vecMag = vecNorm.multiply(0.025);
            int stages = (int)(vecOrig.mag() / vecMag.mag());
            double len = (double)(-ClientTickHandler.ticksInGame) / 100.0 + (double)new Random(dir.ordinal() ^ tile.func_174877_v().hashCode()).nextInt(10000);
            double add = vecMag.mag();
            double rand = Math.random() - 0.5;
            IVertexBuilder buffer = buffers.getBuffer(RenderHelper.LINE_1);
            for (int i = 0; i < stages; ++i) {
                RenderTileRedString.addVertexAtWithTranslation(ms, buffer, color, dir, vecApply.x, vecApply.y, vecApply.z, rand, len);
                rand = Math.random() - 0.5;
                vecApply = vecApply.add(vecMag);
                RenderTileRedString.addVertexAtWithTranslation(ms, buffer, color, dir, vecApply.x, vecApply.y, vecApply.z, rand, len += add);
            }
            ms.func_227865_b_();
        }
    }

    private static void addVertexAtWithTranslation(MatrixStack ms, IVertexBuilder buffer, int color, Direction dir, double xpos, double ypos, double zpos, double rand, double l) {
        double freq = 20.0;
        float sizeAlpha = (float)transparency / 10.0f;
        double ampl = (0.15 * (Math.sin(l * 2.0) * 0.5 + 0.5) + 0.1) * (double)sizeAlpha;
        double randMul = 0.05;
        double x = xpos + Math.sin(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_82601_c()) - 1) + rand * randMul;
        double y = ypos + Math.cos(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_96559_d()) - 1) + rand * randMul;
        double z = zpos + (dir.func_96559_d() == 0 ? Math.sin(l * freq) : Math.cos(l * freq)) * ampl * (double)Math.abs(Math.abs(dir.func_82599_e()) - 1) + rand * randMul;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.func_227888_a_(ms.func_227866_c_().func_227870_a_(), (float)x, (float)y, (float)z).func_225586_a_(r, g, b, a).func_181675_d();
    }
}

