/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;

public interface IFloatingFlower {
    public ItemStack getDisplayStack();

    public IslandType getIslandType();

    public void setIslandType(IslandType var1);

    public static class IslandType {
        private static final Map<String, IslandType> registry = new HashMap<String, IslandType>();
        public static final IslandType GRASS = new IslandType("GRASS");
        public static final IslandType PODZOL = new IslandType("PODZOL");
        public static final IslandType MYCEL = new IslandType("MYCEL");
        public static final IslandType SNOW = new IslandType("SNOW");
        public static final IslandType DRY = new IslandType("DRY");
        public static final IslandType GOLDEN = new IslandType("GOLDEN");
        public static final IslandType VIVID = new IslandType("VIVID");
        public static final IslandType SCORCHED = new IslandType("SCORCHED");
        public static final IslandType INFUSED = new IslandType("INFUSED");
        public static final IslandType MUTATED = new IslandType("MUTATED");
        private final String typeName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IslandType(String name) {
            this.typeName = name;
            Map<String, IslandType> map = registry;
            synchronized (map) {
                if (registry.containsKey(name)) {
                    throw new IllegalArgumentException(name + " already registered!");
                }
                registry.put(name, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IslandType ofType(String typeStr) {
            Map<String, IslandType> map = registry;
            synchronized (map) {
                IslandType type = registry.get(typeStr);
                return type == null ? GRASS : type;
            }
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static class Storage
    implements Capability.IStorage<IFloatingFlower> {
        @Nullable
        public INBT writeNBT(Capability<IFloatingFlower> capability, IFloatingFlower instance, Direction side) {
            CompoundNBT ret = new CompoundNBT();
            ret.func_74778_a("islandType", instance.getIslandType().typeName);
            return ret;
        }

        public void readNBT(Capability<IFloatingFlower> capability, IFloatingFlower instance, Direction side, INBT nbt) {
            IslandType t;
            if (nbt instanceof CompoundNBT && (t = IslandType.ofType(((CompoundNBT)nbt).func_74779_i("islandType"))) != null) {
                instance.setIslandType(t);
            }
        }
    }
}

