/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CheckEnergy
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final MinMaxBounds.IntBound energy;

    public CheckEnergy(MinMaxBounds.IntBound energy) {
        this.energy = energy;
    }

    public boolean test(LootContext ctx) {
        LazyOptional energyCap;
        IEnergyStorage energyStorage;
        TileEntity tile;
        Vector3d pos = (Vector3d)ctx.func_216031_c(LootParameters.field_237457_g_);
        if (pos != null && (tile = ctx.func_202879_g().func_175625_s(new BlockPos(pos))) != null && (energyStorage = (IEnergyStorage)(energyCap = tile.getCapability(CapabilityEnergy.ENERGY)).orElse(null)) != null) {
            return this.energy.func_211339_d(energyStorage.getEnergyStored());
        }
        return false;
    }

    public LootConditionType func_230419_b_() {
        return Bookshelf.instance.conditionCheckEnergy;
    }

    static class Serializer
    implements ILootSerializer<CheckEnergy> {
        Serializer() {
        }

        public void serialize(JsonObject json, CheckEnergy value, JsonSerializationContext context) {
            json.add("value", value.energy.func_200321_c());
        }

        public CheckEnergy deserialize(JsonObject json, JsonDeserializationContext context) {
            return new CheckEnergy(MinMaxBounds.IntBound.func_211344_a((JsonElement)json));
        }
    }
}

