/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class BlockIngredientCheckState
extends BlockIngredient {
    public static final ResourceLocation ID = new ResourceLocation("bookshelf", "check_state");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<BlockState> validStates;

    public BlockIngredientCheckState(List<BlockState> validStates) {
        this.validStates = validStates;
    }

    @Override
    public boolean test(BlockState t) {
        return this.validStates.contains(t);
    }

    @Override
    public Collection<BlockState> getValidStates() {
        return this.validStates;
    }

    @Override
    public ResourceLocation getSerializeId() {
        return ID;
    }

    static class Serializer
    implements IBlockIngredientSerializer<BlockIngredientCheckState> {
        Serializer() {
        }

        @Override
        public BlockIngredientCheckState read(JsonElement json) {
            List<BlockState> states = Serializers.BLOCK_STATE.readList(json.getAsJsonObject(), "state");
            return new BlockIngredientCheckState(states);
        }

        @Override
        public JsonElement write(BlockIngredientCheckState ingredient) {
            JsonObject obj = new JsonObject();
            obj.add("state", Serializers.BLOCK_STATE.writeList(ingredient.validStates));
            return obj;
        }

        @Override
        public BlockIngredientCheckState read(PacketBuffer buf) {
            List<BlockState> states = Serializers.BLOCK_STATE.readList(buf);
            return new BlockIngredientCheckState(states);
        }

        @Override
        public void write(PacketBuffer buf, BlockIngredientCheckState ingredient) {
            Serializers.BLOCK_STATE.writeList(buf, ingredient.validStates);
        }
    }
}

