/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.block.BlockSpectral;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.type.SpectralBlockType;
import wayoftime.bloodmagic.tile.base.TileBase;

public class TileSpectral
extends TileBase {
    @ObjectHolder(value="bloodmagic:spectral")
    public static TileEntityType<TileSpectral> TYPE;
    public BlockState storedBlock;

    public TileSpectral(TileEntityType<?> type) {
        super(type);
    }

    public TileSpectral() {
        this(TYPE);
    }

    public static void createOrRefreshSpectralBlock(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return;
        }
        BlockState potentialFluidBlockState = world.func_180495_p(pos);
        if (TileSpectral.isFluidBlock(potentialFluidBlockState.func_177230_c())) {
            world.func_180501_a(pos, ((Block)BloodMagicBlocks.SPECTRAL.get()).func_176223_P(), 3);
            TileEntity spectralTile = world.func_175625_s(pos);
            if (spectralTile instanceof TileSpectral) {
                ((TileSpectral)spectralTile).setContainedBlockInfo(potentialFluidBlockState);
                world.func_205220_G_().func_205360_a(pos, (Object)spectralTile.func_195044_w().func_177230_c(), 100);
            }
        } else if (potentialFluidBlockState.func_177230_c() == BloodMagicBlocks.SPECTRAL.get() && potentialFluidBlockState.func_177229_b(BlockSpectral.SPECTRAL_STATE) == SpectralBlockType.LEAKING) {
            world.func_180501_a(pos, ((Block)BloodMagicBlocks.SPECTRAL.get()).func_176223_P(), 0);
        }
    }

    public void revertToFluid() {
        this.field_145850_b.func_180501_a(this.field_174879_c, this.storedBlock, 3);
    }

    public static boolean isFluidBlock(Block block) {
        return block instanceof FlowingFluidBlock;
    }

    public void setContainedBlockInfo(BlockState state) {
        this.storedBlock = state;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.storedBlock = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("BlockState"));
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        tag.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.storedBlock));
        return tag;
    }
}

