/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.tile.base.TileBase;

public class TileInversionPillar
extends TileBase
implements ICommandSource {
    @ObjectHolder(value="bloodmagic:inversion_pillar")
    public static TileEntityType<TileInversionPillar> TYPE;
    protected BlockPos teleportPos = BlockPos.field_177992_a;
    protected RegistryKey<World> destinationKey;

    public TileInversionPillar(TileEntityType<?> type) {
        super(type);
    }

    public TileInversionPillar() {
        this(TYPE);
    }

    public void setDestination(World destinationWorld, BlockPos destinationPos) {
        this.destinationKey = destinationWorld.func_234923_W_();
        this.teleportPos = destinationPos;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        CompoundNBT positionTag = tag.func_74775_l("dungeon_teleport_pos");
        this.teleportPos = new BlockPos(positionTag.func_74762_e("xCoord"), positionTag.func_74762_e("yCoord"), positionTag.func_74762_e("zCoord"));
        if (tag.func_74764_b("dungeon_teleport_key")) {
            String key = tag.func_74779_i("dungeon_teleport_key");
            this.destinationKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(key));
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        CompoundNBT positionTag = new CompoundNBT();
        positionTag.func_74768_a("xCoord", this.teleportPos.func_177958_n());
        positionTag.func_74768_a("yCoord", this.teleportPos.func_177956_o());
        positionTag.func_74768_a("zCoord", this.teleportPos.func_177952_p());
        tag.func_218657_a("dungeon_teleport_pos", (INBT)positionTag);
        if (this.destinationKey != null) {
            tag.func_74778_a("dungeon_teleport_key", this.destinationKey.func_240901_a_().toString());
        }
        return tag;
    }

    public void handlePlayerInteraction(PlayerEntity player) {
        if (this.teleportPos.equals((Object)BlockPos.field_177992_a)) {
            return;
        }
        this.teleportPlayerToLocation((ServerWorld)this.field_145850_b, player, this.destinationKey, this.teleportPos);
    }

    public CommandSource getCommandSource(ServerWorld world) {
        return new CommandSource((ICommandSource)this, new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()), Vector2f.field_189974_a, world, 2, "Inversion Pillar", (ITextComponent)new StringTextComponent("Inversion Pillar"), world.func_73046_m(), (Entity)null);
    }

    public void teleportPlayerToLocation(ServerWorld serverWorld, PlayerEntity player, RegistryKey<World> destination, BlockPos destinationPos) {
        String command = this.getTextCommandForTeleport(destination, player, (double)destinationPos.func_177958_n() + 0.5, destinationPos.func_177956_o(), (double)destinationPos.func_177952_p() + 0.5);
        MinecraftServer mcServer = serverWorld.func_73046_m();
        mcServer.func_195571_aL().func_197059_a(this.getCommandSource(serverWorld), command);
    }

    public String getTextCommandForTeleport(RegistryKey<World> destination, PlayerEntity player, double posX, double posY, double posZ) {
        String playerName = player.func_200200_C_().getString();
        return "execute in " + destination.func_240901_a_().toString() + " run teleport " + playerName + " " + posX + " " + posY + " " + posZ;
    }

    public void func_145747_a(ITextComponent component, UUID senderUUID) {
    }

    public boolean func_195039_a() {
        return false;
    }

    public boolean func_195040_b() {
        return false;
    }

    public boolean func_195041_r_() {
        return false;
    }
}

