/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffect;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRegistry;
import wayoftime.bloodmagic.tile.TileInventory;

public class TileAlchemyArray
extends TileInventory
implements ITickableTileEntity {
    @ObjectHolder(value="bloodmagic:alchemyarray")
    public static TileEntityType<TileAlchemyArray> TYPE;
    public boolean isActive = false;
    public int activeCounter = 0;
    public Direction rotation = Direction.func_176731_b((int)0);
    public int rotateCooldown = 0;
    private String key = "";
    public AlchemyArrayEffect arrayEffect;
    private boolean doDropIngredients = true;

    public TileAlchemyArray(TileEntityType<?> type) {
        super(type, 2, "alchemyarray");
    }

    public TileAlchemyArray() {
        this(TYPE);
    }

    public void onEntityCollidedWithBlock(BlockState state, Entity entity) {
        if (this.arrayEffect != null) {
            this.arrayEffect.onEntityCollidedWithBlock(this, this.func_145831_w(), this.field_174879_c, state, entity);
        }
    }

    @Override
    public void deserialize(CompoundNBT tagCompound) {
        super.deserialize(tagCompound);
        this.isActive = tagCompound.func_74767_n("isActive");
        this.activeCounter = tagCompound.func_74762_e("activeCounter");
        this.key = tagCompound.func_74779_i("stringKey");
        this.doDropIngredients = !tagCompound.func_74764_b("doDropIngredients") ? true : tagCompound.func_74767_n("doDropIngredients");
        this.rotation = Direction.func_176731_b((int)tagCompound.func_74762_e("direction"));
        CompoundNBT arrayTag = tagCompound.func_74775_l("arrayTag");
        if (this.arrayEffect != null) {
            this.arrayEffect.readFromNBT(arrayTag);
        }
    }

    public void doDropIngredients(boolean drop) {
        this.doDropIngredients = drop;
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tagCompound) {
        super.serialize(tagCompound);
        tagCompound.func_74757_a("isActive", this.isActive);
        tagCompound.func_74768_a("activeCounter", this.activeCounter);
        tagCompound.func_74778_a("stringKey", "".equals(this.key) ? "empty" : this.key.toString());
        tagCompound.func_74757_a("doDropIngredients", this.doDropIngredients);
        tagCompound.func_74768_a("direction", this.rotation.func_176736_b());
        CompoundNBT arrayTag = new CompoundNBT();
        if (this.arrayEffect != null) {
            this.arrayEffect.writeToNBT(arrayTag);
        }
        tagCompound.func_218657_a("arrayTag", (INBT)arrayTag);
        return tagCompound;
    }

    public void func_73660_a() {
        if (this.isActive && this.attemptCraft()) {
            ++this.activeCounter;
        } else {
            this.isActive = false;
            this.doDropIngredients = true;
            this.activeCounter = 0;
            this.arrayEffect = null;
            this.key = "empty";
        }
        if (this.rotateCooldown > 0) {
            --this.rotateCooldown;
        }
    }

    public boolean attemptCraft() {
        if (this.arrayEffect != null) {
            this.isActive = true;
        } else {
            AlchemyArrayEffect effect = AlchemyArrayRegistry.getEffect(this.field_145850_b, this.func_70301_a(0), this.func_70301_a(1));
            if (effect == null) {
                return false;
            }
            this.arrayEffect = effect;
        }
        if (this.arrayEffect != null) {
            this.isActive = true;
            if (this.arrayEffect.update(this, this.activeCounter)) {
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
                this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public Direction getRotation() {
        return this.rotation;
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0 || slot == 1;
    }
}

