/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;
import wayoftime.bloodmagic.structures.StoneToOreProcessor;
import wayoftime.bloodmagic.util.BMLog;

public class Dungeon {
    /*
     * WARNING - void declaration
     */
    public static boolean placeStructureAtPosition(Random rand, ServerWorld world, BlockPos pos) {
        String initialDoorName = "default";
        long startTime = System.nanoTime();
        HashMap<String, Map<Object, Object>> availableDoorMasterMap = new HashMap<String, Map<Object, Object>>();
        ArrayList<AreaDescriptor> descriptorList = new ArrayList<AreaDescriptor>();
        HashMap<BlockPos, Pair> roomMap = new HashMap<BlockPos, Pair>();
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(true);
        settings.func_186218_a(null);
        settings.func_215222_a((StructureProcessor)new StoneToOreProcessor(0.0f));
        settings.func_215223_c(true);
        DungeonRoom room = Dungeon.getRandomRoom(rand);
        roomMap.put(pos, Pair.of((Object)room, (Object)settings.func_186217_a()));
        descriptorList.addAll(room.getAreaDescriptors(settings, pos));
        Map<Direction, List<BlockPos>> availableDoorMap = new HashMap<Direction, List<BlockPos>>();
        availableDoorMasterMap.put(initialDoorName, availableDoorMap);
        for (Direction facing : Direction.values()) {
            Object doorList;
            if (availableDoorMap.containsKey(facing)) {
                doorList = (List<BlockPos>)availableDoorMap.get(facing);
                doorList.addAll(room.getDoorOffsetsForFacing(settings, initialDoorName, facing, pos));
                continue;
            }
            doorList = room.getDoorOffsetsForFacing(settings, initialDoorName, facing, pos);
            availableDoorMap.put(facing, (List<BlockPos>)doorList);
        }
        for (int i = 0; i < 100; ++i) {
            void var19_23;
            ArrayList typeList = new ArrayList(availableDoorMasterMap.keySet());
            String doorName = (String)typeList.get(rand.nextInt(typeList.size()));
            availableDoorMap = null;
            if (availableDoorMasterMap.containsKey(doorName)) {
                availableDoorMap = (Map)availableDoorMasterMap.get(doorName);
            } else {
                availableDoorMap = new HashMap();
                availableDoorMasterMap.put(doorName, availableDoorMap);
            }
            ArrayList<Direction> facingList = new ArrayList<Direction>();
            for (Map.Entry entry : availableDoorMap.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                facingList.add((Direction)entry.getKey());
            }
            Collections.shuffle(facingList);
            Pair removedDoor1 = null;
            Object var19_26 = null;
            BlockPos roomLocation = null;
            block3: for (Direction direction : facingList) {
                Direction[] oppositeDoorFacing = direction.func_176734_d();
                List availableDoorList = (List)availableDoorMap.get(direction);
                Collections.shuffle(availableDoorList);
                Rotation randRotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
                settings.func_186220_a(randRotation);
                DungeonRoom testingRoom = Dungeon.getRandomRoom(rand);
                List<BlockPos> otherDoorList = testingRoom.getDoorOffsetsForFacing(settings, doorName, (Direction)oppositeDoorFacing, BlockPos.field_177992_a);
                if (otherDoorList == null || otherDoorList.isEmpty()) continue;
                Collections.shuffle(otherDoorList);
                BlockPos testDoor = otherDoorList.get(0);
                Iterator iterator = availableDoorList.iterator();
                if (!iterator.hasNext()) break;
                BlockPos availableDoor = (BlockPos)iterator.next();
                roomLocation = availableDoor.func_177973_b((Vector3i)testDoor).func_177971_a(direction.func_176730_m());
                List<AreaDescriptor> descriptors = testingRoom.getAreaDescriptors(settings, roomLocation);
                for (AreaDescriptor testDesc : descriptors) {
                    for (AreaDescriptor currentDesc : descriptorList) {
                        if (!testDesc.intersects(currentDesc)) continue;
                        break block3;
                    }
                }
                settings.func_215219_b();
                settings.func_215222_a((StructureProcessor)new StoneToOreProcessor(testingRoom.oreDensity));
                roomMap.put(roomLocation, Pair.of((Object)testingRoom, (Object)settings.func_186217_a()));
                descriptorList.addAll(descriptors);
                removedDoor1 = Pair.of((Object)direction, (Object)availableDoor);
                Pair pair = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.func_177971_a((Vector3i)roomLocation));
                room = testingRoom;
                break;
            }
            if (removedDoor1 != null) {
                for (String string : room.doorMap.keySet()) {
                    availableDoorMap = null;
                    if (availableDoorMasterMap.containsKey(string)) {
                        availableDoorMap = (Map)availableDoorMasterMap.get(string);
                    } else {
                        availableDoorMap = new HashMap();
                        availableDoorMasterMap.put(string, availableDoorMap);
                    }
                    for (Direction facing : Direction.values()) {
                        List<BlockPos> doorList;
                        if (availableDoorMap.containsKey(facing)) {
                            doorList = (List<BlockPos>)availableDoorMap.get(facing);
                            doorList.addAll(room.getDoorOffsetsForFacing(settings, string, facing, roomLocation));
                            continue;
                        }
                        doorList = room.getDoorOffsetsForFacing(settings, string, facing, roomLocation);
                        availableDoorMap.put(facing, doorList);
                    }
                    Direction face = (Direction)removedDoor1.getKey();
                    if (!availableDoorMap.containsKey(face)) continue;
                    ((List)availableDoorMap.get(face)).remove(removedDoor1.getRight());
                }
            }
            if (var19_23 == null) continue;
            Direction face = (Direction)var19_23.getKey();
            for (Map.Entry entry : availableDoorMasterMap.entrySet()) {
                availableDoorMap = (Map)entry.getValue();
                if (!availableDoorMap.containsKey(face)) continue;
                ((List)availableDoorMap.get(face)).remove(var19_23.getRight());
            }
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        BMLog.DEBUG.info("Duration: " + duration + "(ns), " + duration / 1000000L + "(ms)", new Object[0]);
        for (Map.Entry entry : roomMap.entrySet()) {
            BlockPos placementPos = (BlockPos)entry.getKey();
            DungeonRoom placedRoom = (DungeonRoom)((Pair)entry.getValue()).getKey();
            PlacementSettings placementSettings = (PlacementSettings)((Pair)entry.getValue()).getValue();
            placedRoom.placeStructureAtPosition(rand, placementSettings, world, placementPos);
        }
        return false;
    }

    public static DungeonRoom getRandomRoom(Random rand) {
        return DungeonRoomRegistry.getRandomDungeonRoom(rand);
    }
}

