/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="zephyr")
public class RitualZephyr
extends Ritual {
    public static final String ZEPHYR_RANGE = "zephyrRange";
    public static final String CHEST_RANGE = "chest";

    public RitualZephyr() {
        super("ritualZephyr", 0, 1000, "ritual.bloodmagic.zephyrRitual");
        this.addBlockRange(ZEPHYR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(ZEPHYR_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        if (!masterRitualStone.getWorldObj().field_72995_K && tileInventory != null) {
            if (currentEssence < this.getRefreshCost()) {
                masterRitualStone.getOwnerNetwork().causeNausea();
                return;
            }
            AreaDescriptor zephyrRange = masterRitualStone.getBlockRange(ZEPHYR_RANGE);
            List itemList = world.func_217357_a(ItemEntity.class, zephyrRange.getAABB(masterRitualStone.getMasterBlockPos()));
            int count = 0;
            for (ItemEntity entityItem : itemList) {
                if (!entityItem.func_70089_S()) continue;
                ItemStack copyStack = entityItem.func_92059_d().func_77946_l();
                int originalAmount = copyStack.func_190916_E();
                ItemStack newStack = Utils.insertStackIntoTile(copyStack, tileInventory, Direction.DOWN);
                if (!newStack.func_190926_b() && newStack.func_190916_E() < originalAmount) {
                    ++count;
                    if (newStack.func_190926_b()) {
                        entityItem.func_70106_y();
                    }
                    entityItem.func_92059_d().func_190920_e(newStack.func_190916_E());
                }
                if (!newStack.func_190926_b()) continue;
                entityItem.func_70106_y();
            }
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * Math.min(count, 100)));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -1, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualZephyr();
    }
}

