/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="upgrade_remove")
public class RitualUpgradeRemove
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualUpgradeRemove() {
        super("ritualUpgradeRemove", 0, 25000, "ritual.bloodmagic.upgradeRemoveRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor checkRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List playerList = world.func_217357_a(PlayerEntity.class, checkRange.getAABB(pos));
        for (PlayerEntity player : playerList) {
            if (!LivingUtil.hasFullSet(player)) continue;
            boolean removedUpgrade = false;
            ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
            LivingStats stats = LivingStats.fromPlayer(player);
            if (stats == null) continue;
            Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
            for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
                int exp = entry.getValue().intValue();
                LivingUpgrade upgrade = entry.getKey();
                int level = upgrade.getLevel(exp);
                if (level >= 1) {
                    ItemStack upgradeStack = new ItemStack((IItemProvider)BloodMagicItems.LIVING_TOME.get());
                    ((ILivingContainer)BloodMagicItems.LIVING_TOME.get()).updateLivingStats(upgradeStack, new LivingStats().setMaxPoints(upgrade.getLevelCost(exp)).addExperience(upgrade.getKey(), exp));
                    ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), upgradeStack);
                    world.func_217376_c((Entity)item);
                    removedUpgrade = true;
                }
                stats.resetExperience(upgrade.getKey());
            }
            if (!removedUpgrade) continue;
            LivingStats.toPlayer(player, stats);
            masterRitualStone.setActive(false);
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            lightningboltentity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            lightningboltentity.func_233623_a_(true);
            world.func_217376_c((Entity)lightningboltentity);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualUpgradeRemove();
    }
}

