/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class AbstractEntityThrowingDagger
extends ProjectileItemEntity {
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    public AbstractArrowEntity.PickupStatus pickupStatus = AbstractArrowEntity.PickupStatus.ALLOWED;
    public int arrowShake;
    private int ticksInGround;
    private double damage = 2.0;
    private int knockbackStrength;
    private SoundEvent hitSound = this.getHitEntitySound();
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    private double willDrop = 0.0;
    private EnumDemonWillType willType = EnumDemonWillType.DEFAULT;

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, World world) {
        super(type, world);
    }

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, ItemStack stack, World worldIn, LivingEntity throwerIn) {
        super(type, throwerIn, worldIn);
        this.func_213884_b(stack);
        if (throwerIn instanceof PlayerEntity) {
            this.pickupStatus = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
    }

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, ItemStack stack, World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
        this.func_213884_b(stack);
    }

    public void func_213884_b(ItemStack stack) {
        super.func_213884_b(stack);
    }

    protected Item func_213885_i() {
        return (Item)BloodMagicItems.THROWING_DAGGER.get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        this.func_70030_z();
        boolean flag = this.getNoClip();
        flag = false;
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AbstractEntityThrowingDagger.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround && !flag) {
            if (this.inBlockState != blockstate && this.func_234593_u_()) {
                this.func_234594_z_();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.timeInGround;
        } else {
            Vector3d vector3d3;
            this.timeInGround = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AbstractEntityThrowingDagger.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = AbstractEntityThrowingDagger.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = AbstractEntityThrowingDagger.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.getWaterDrag();
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        if (typeIn != MoverType.SELF && this.func_234593_u_()) {
            this.func_234594_z_();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74757_a("inGround", this.inGround);
        compound.func_74774_a("pickup", (byte)this.pickupStatus.ordinal());
        compound.func_74780_a("damage", this.damage);
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.hitSound).toString());
        compound.func_74780_a("willDrop", this.willDrop);
        compound.func_74778_a("willType", this.willType.name);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.pickupStatus = AbstractArrowEntity.PickupStatus.func_188795_a((int)compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.pickupStatus = compound.func_74767_n("player") ? AbstractArrowEntity.PickupStatus.ALLOWED : AbstractArrowEntity.PickupStatus.DISALLOWED;
        }
        this.willDrop = compound.func_74769_h("willDrop");
        this.willType = EnumDemonWillType.getType(compound.func_74779_i("willType"));
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        super.func_213868_a(p_213868_1_);
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)this.damage, (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if (this.getIsCritical()) {
            long j = this.field_70146_Z.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.func_234616_v_()) == null) {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int k = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (!entity.func_70089_S() && entity1 instanceof PlayerEntity && entity instanceof LivingEntity) {
                PlayerDemonWillHandler.addDemonWill(this.willType, (PlayerEntity)entity1, this.getWillDropForMobHealth(((LivingEntity)entity).func_110138_aP()));
            }
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockbackStrength > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.daggerHit(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!entity.func_70089_S() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
            }
            this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(k);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.getArrowStack(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && (this.inGround || this.getNoClip()) && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED || this.pickupStatus == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d || this.getNoClip() && this.func_234616_v_().func_110124_au() == entityIn.func_110124_au();
            if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                this.field_70170_p.func_184148_a(null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + 0.5, entityIn.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.func_70106_y();
            }
        }
    }

    protected ItemStack getArrowStack() {
        return this.func_184543_l();
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        this.inBlockState = this.field_70170_p.func_180495_p(p_230299_1_.func_216350_a());
        super.func_230299_a_(p_230299_1_);
        Vector3d vector3d = p_230299_1_.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.getHitGroundSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.arrowShake = 7;
        this.setHitSound(SoundEvents.field_187731_t);
        this.func_213870_w();
    }

    private void func_234594_z_() {
        this.inGround = false;
        Vector3d vector3d = this.func_213322_ci();
        this.func_213317_d(vector3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    private boolean func_234593_u_() {
        return this.inGround && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    protected void func_225516_i_() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 1200) {
            this.func_70106_y();
        }
    }

    protected void daggerHit(LivingEntity living) {
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    private void func_213870_w() {
        if (this.hitEntities != null) {
            this.hitEntities.clear();
        }
        if (this.piercedEntities != null) {
            this.piercedEntities.clear();
        }
    }

    public void setHitSound(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    public boolean getNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return false;
    }

    public boolean getIsCritical() {
        return false;
    }

    public byte getPierceLevel() {
        return 0;
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::func_230298_a_);
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) && (this.piercedEntities == null || !this.piercedEntities.contains(p_230298_1_.func_145782_y()));
    }

    public void setWillDrop(double willDrop) {
        this.willDrop = willDrop;
    }

    public double getWillDropForMobHealth(double hp) {
        return this.willDrop * hp / 20.0;
    }

    public void setWillType(EnumDemonWillType type) {
        this.willType = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData makeParticle() {
        ItemStack itemstack = this.func_213882_k();
        return itemstack.func_190926_b() ? ParticleTypes.field_197595_F : new ItemParticleData(ParticleTypes.field_197591_B, itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            IParticleData iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(iparticledata, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

