/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeFilterMergeAlchemyTable;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class FilterMergeAlchemyTableRecipeSerializer<RECIPE extends RecipeFilterMergeAlchemyTable>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public FilterMergeAlchemyTableRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray filterElement = JSONUtils.func_151202_d((JsonObject)json, (String)"filter") ? JSONUtils.func_151214_t((JsonObject)json, (String)"filter") : JSONUtils.func_152754_s((JsonObject)json, (String)"filter");
        Ingredient filter = Ingredient.func_199802_a((JsonElement)filterElement);
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        if (json.has("input") && JSONUtils.func_151202_d((JsonObject)json, (String)"input")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"input");
            for (JsonElement element : mainArray) {
                if (inputList.size() >= 6) break;
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray();
                } else {
                    element.getAsJsonObject();
                }
                inputList.add(Ingredient.func_199802_a((JsonElement)element));
            }
        }
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        int syphon = JSONUtils.func_151203_m((JsonObject)json, (String)"syphon");
        int ticks = JSONUtils.func_151203_m((JsonObject)json, (String)"ticks");
        int minimumTier = JSONUtils.func_151203_m((JsonObject)json, (String)"upgradeLevel");
        return this.factory.create(recipeId, filter, inputList, output, syphon, ticks, minimumTier);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        Ingredient filter = Ingredient.func_199566_b((PacketBuffer)buffer);
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack output = buffer.func_150791_c();
        int syphon = buffer.readInt();
        int ticks = buffer.readInt();
        int minimumTier = buffer.readInt();
        return this.factory.create(recipeId, filter, input, output, syphon, ticks, minimumTier);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipeFilterMergeAlchemyTable)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeFilterMergeAlchemyTable> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, List<Ingredient> var3, ItemStack var4, int var5, int var6, int var7);
    }
}

