/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.common.item.BMItemTier;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSentientSword
extends SwordItem
implements IDemonWillWeapon,
IMultiWillTool {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0};
    public static double[] destructiveDamageAdded = new double[]{1.5, 2.25, 3.0, 3.75, 4.5, 5.25, 6.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.25, 2.5};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.25, 2.5};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.25};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};
    public static double[] healthBonus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public static double[] vengefulAttackSpeed = new double[]{-2.1, -2.0, -1.8, -1.7, -1.6, -1.6, -1.5};
    public static double[] destructiveAttackSpeed = new double[]{-2.6, -2.7, -2.8, -2.9, -3.0, -3.0, -3.0};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600, 700, 800};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100, 120, 150};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public static double[] movementSpeed = new double[]{0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4};

    public ItemSentientSword() {
        super((IItemTier)BMItemTier.SENTIENT, 6, -2.6f, new Item.Properties().func_200918_c(520).func_200916_a(BloodMagic.TAB));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return BloodMagicTags.CRYSTAL_DEMON.func_230235_a_((Object)repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }

    public void recalculatePowers(ItemStack stack, World world, PlayerEntity player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.recalculatePowers(stack, type, soulsRemaining);
    }

    public void recalculatePowers(ItemStack stack, EnumDemonWillType type, double will) {
        this.setCurrentType(stack, will > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(stack, will);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        double extraDamage = this.getExtraDamage(type, level);
        this.setActivatedState(stack, will > 16.0);
        this.setDrainOfActivatedSword(stack, drain);
        this.setDamageOfActivatedSword(stack, 5.0 + extraDamage);
        this.setStaticDropOfActivatedSword(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedSword(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setAttackSpeedOfSword(stack, level >= 0 ? this.getAttackSpeed(type, level) : -2.4);
        this.setHealthBonusOfSword(stack, level >= 0 ? this.getHealthBonus(type, level) : 0.0);
        this.setSpeedOfSword(stack, level >= 0 ? this.getMovementSpeed(type, level) : 0.0);
    }

    public boolean getActivated(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.func_190926_b()) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return stack;
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return vengefulAttackSpeed[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveAttackSpeed[willBracket];
            }
        }
        return -2.4;
    }

    public double getHealthBonus(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return healthBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getMovementSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return movementSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, LivingEntity target, LivingEntity attacker) {
        switch (type) {
            case CORROSIVE: {
                target.func_195064_c(new EffectInstance(Effects.field_82731_v, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.func_70089_S()) break;
                float absorption = attacker.func_110139_bj();
                attacker.func_195064_c(new EffectInstance(Effects.field_76444_x, absorptionTime[willBracket], 127, false, false));
                attacker.func_110149_m((float)Math.min((double)(absorption + target.func_110138_aP() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (super.func_77644_a(stack, target, attacker)) {
            if (attacker instanceof PlayerEntity) {
                PlayerEntity attackerPlayer = (PlayerEntity)attacker;
                this.recalculatePowers(stack, attackerPlayer.func_130014_f_(), attackerPlayer);
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                this.applyEffectToEntity(type, willBracket, target, (LivingEntity)attackerPlayer);
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        this.recalculatePowers(player.func_184586_b(hand), world, player);
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private int getLevel(ItemStack stack, double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sentientSword.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.GRAY));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        this.recalculatePowers(stack, player.func_130014_f_(), player);
        double drain = this.getDrainOfActivatedSword(stack);
        if (drain > 0.0) {
            EnumDemonWillType type = this.getCurrentType(stack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (drain > soulsRemaining) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, drain);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public List<ItemStack> getRandomDemonWillDrop(LivingEntity killedEntity, LivingEntity attackingEntity, ItemStack stack, int looting) {
        IDemonWill soul;
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL && !(killedEntity instanceof IMob)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof SlimeEntity ? 0.67 : 1.0;
        EnumDemonWillType type = this.getCurrentType(stack);
        switch (type) {
            case CORROSIVE: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_CORROSIVE.get();
                break;
            }
            case DESTRUCTIVE: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_DESTRUCTIVE.get();
                break;
            }
            case STEADFAST: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_STEADFAST.get();
                break;
            }
            case VENGEFUL: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_VENGEFUL.get();
                break;
            }
            default: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get();
            }
        }
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.func_130014_f_().field_73012_v.nextDouble() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.func_130014_f_().field_73012_v.nextDouble() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.func_110138_aP() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageOfActivatedSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(new UUID(0L, 31818145L), "Weapon modifier", this.getHealthBonusOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(new UUID(0L, 4218052L), "Weapon modifier", this.getSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDamage");
    }

    public void setDamageOfActivatedSword(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDamage", damage);
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDrop", drop);
    }

    public double getHealthBonusOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordHealth");
    }

    public void setHealthBonusOfSword(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordHealth", hp);
    }

    public double getAttackSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordAttackSpeed");
    }

    public void setAttackSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordAttackSpeed", speed);
    }

    public double getSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordSpeed");
    }

    public void setSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordSpeed", speed);
    }
}

