/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.client.key.IKeybindable;
import wayoftime.bloodmagic.client.key.KeyBindings;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.inventory.ContainerHolding;
import wayoftime.bloodmagic.common.item.inventory.InventoryHolding;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilHolding
extends ItemSigilBase
implements IKeybindable,
IAltarReader,
ISigil.Holding,
INamedContainerProvider {
    public static final int inventorySize = 5;

    public ItemSigilHolding() {
        super("holding");
    }

    @Override
    public void onKeyPressed(ItemStack stack, PlayerEntity player, KeyBindings key, boolean showInChat) {
        if (stack == player.func_184614_ca() && stack.func_77973_b() instanceof ItemSigilHolding && key.equals((Object)KeyBindings.OPEN_HOLDING)) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sigil.holding.press", new Object[]{new TranslationTextComponent(KeyBindings.OPEN_HOLDING.getKey().func_197982_m()).func_240699_a_(TextFormatting.ITALIC)}).func_240699_a_(TextFormatting.GRAY));
        if (!stack.func_77942_o()) {
            return;
        }
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        ItemStack item = (ItemStack)inv.get(currentSlot);
        for (int i = 0; i < 5; ++i) {
            ItemStack invStack = (ItemStack)inv.get(i);
            if (invStack.func_190926_b()) continue;
            if (!item.func_190926_b() && invStack == item) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sigil.holding.sigilInSlot", new Object[]{i + 1, invStack.func_200301_q().func_230531_f_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.UNDERLINE})}));
                continue;
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sigil.holding.sigilInSlot", new Object[]{i + 1, invStack.func_200301_q()}));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResultType.FAIL;
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = (ItemStack)inv.get(currentSlot);
        if (itemUsing.func_190926_b() || ((IBindable)itemUsing.func_77973_b()).getBinding(itemUsing) == null) {
            return ActionResultType.PASS;
        }
        ActionResultType result = itemUsing.func_77973_b().func_195939_a(context);
        this.saveInventory(stack, inv);
        return result;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = (ItemStack)inv.get(currentSlot);
        if (itemUsing.func_190926_b() || ((IBindable)itemUsing.func_77973_b()).getBinding(itemUsing) == null) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        itemUsing.func_77973_b().func_77659_a(world, player, hand);
        this.saveInventory(stack, inv);
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem(ItemStack holdingStack, PlayerEntity player) {
        return (ItemStack)ItemSigilHolding.getInternalInventory(holdingStack).get(ItemSigilHolding.getCurrentItemOrdinal(holdingStack));
    }

    public void saveInventory(ItemStack itemStack, NonNullList<ItemStack> inventory) {
        CompoundNBT itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemTag = new CompoundNBT();
            itemStack.func_77982_d(itemTag);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)itemTag, inventory);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (stack.func_77942_o()) {
            this.tickInternalInventory(stack, world, entity, itemSlot, isSelected);
        }
    }

    public void tickInternalInventory(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        for (ItemStack stack : ItemSigilHolding.getInternalInventory(itemStack)) {
            Binding binding;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBindable) || !(stack.func_77973_b() instanceof ISigil) || (binding = ((IBindable)stack.func_77973_b()).getBinding(stack)) == null) continue;
            stack.func_77973_b().func_77663_a(stack, world, entity, itemSlot, isSelected);
        }
    }

    public static int next(int mode) {
        int index = mode + 1;
        if (index >= 5) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode) {
        int index = mode - 1;
        if (index < 0) {
            index = 5;
        }
        return index;
    }

    private static void initModeTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack = NBTHelper.checkNBT(stack);
            stack.func_77978_p().func_74768_a("currentSigil", 5);
        }
    }

    public static ItemStack getItemStackInSlot(ItemStack itemStack, int slot) {
        if (itemStack.func_77973_b() instanceof ItemSigilHolding) {
            NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(itemStack);
            if (inv != null) {
                return (ItemStack)inv.get(slot == 5 ? 4 : slot);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static int getCurrentItemOrdinal(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(stack);
            int currentSigil = stack.func_77978_p().func_74762_e("currentSigil");
            currentSigil = MathHelper.func_76125_a((int)currentSigil, (int)0, (int)4);
            return currentSigil;
        }
        return 0;
    }

    public static NonNullList<ItemStack> getInternalInventory(ItemStack stack) {
        ItemSigilHolding.initModeTag(stack);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        }
        NonNullList inv = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tagCompound, (NonNullList)inv);
        return inv;
    }

    public static void cycleToNextSigil(ItemStack itemStack, int mode) {
        if (itemStack.func_77973_b() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(itemStack);
            int index = mode;
            if (mode == 120 || mode == -120) {
                int currentIndex = ItemSigilHolding.getCurrentItemOrdinal(itemStack);
                ItemStack currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, currentIndex);
                if (currentItemStack.func_190926_b()) {
                    return;
                }
                if (mode < 0) {
                    index = ItemSigilHolding.next(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = ItemSigilHolding.next(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                } else {
                    index = ItemSigilHolding.prev(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = ItemSigilHolding.prev(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                }
            }
            itemStack.func_77978_p().func_74768_a("currentSigil", index);
        }
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity player) {
        assert (player.func_130014_f_() != null);
        return new ContainerHolding(p_createMenu_1_, player, p_createMenu_2_, new InventoryHolding(player.func_184614_ca()));
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Sigil of Holding");
    }
}

