/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilToggleableBase;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilGreenGrove
extends ItemSigilToggleableBase {
    public ItemSigilGreenGrove() {
        super("green_grove", 150);
    }

    @Override
    public boolean onSigilUse(ItemStack stack, PlayerEntity player, World world, BlockPos blockPos, Direction side, Vector3d vec) {
        if (PlayerHelper.isFakePlayer(player)) {
            return false;
        }
        if (!world.field_72995_K && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed())).isSuccess() && ItemSigilGreenGrove.applyBonemeal(stack, world, blockPos, player)) {
            world.func_217379_c(2005, blockPos, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onSigilUpdate(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected) {
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        int range = 3;
        int verticalRange = 2;
        int posX = (int)Math.round(player.func_226277_ct_() - 0.5);
        int posY = (int)player.func_226278_cu_();
        int posZ = (int)Math.round(player.func_226281_cx_() - 0.5);
        if (worldIn instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            for (int ix = posX - range; ix <= posX + range; ++ix) {
                for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                    for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                        BlockPos blockPos = new BlockPos(ix, iy, iz);
                        BlockState state = worldIn.func_180495_p(blockPos);
                        if (!(state.func_177230_c() instanceof IGrowable) || state.func_177230_c() == Blocks.field_196658_i || worldIn.field_73012_v.nextInt(50) != 0) continue;
                        BlockState preBlockState = worldIn.func_180495_p(blockPos);
                        if (!((IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)serverWorld, blockPos, preBlockState, worldIn.field_72995_K)) continue;
                        ((IGrowable)state.func_177230_c()).func_225535_a_(serverWorld, worldIn.field_73012_v, blockPos, state);
                        BlockState newState = worldIn.func_180495_p(blockPos);
                        if (newState.equals(preBlockState) || worldIn.field_72995_K) continue;
                        worldIn.func_217379_c(2005, blockPos, 0);
                    }
                }
            }
        }
    }

    private static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K)) {
            if (worldIn instanceof ServerWorld && igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) {
                igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, blockstate);
            }
            return true;
        }
        return false;
    }
}

