/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.inventory.InventoryHolding;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public class ContainerHolding
extends Container {
    public final InventoryHolding inventoryHolding;
    private final int PLAYER_INVENTORY_ROWS = 3;
    private final int PLAYER_INVENTORY_COLUMNS = 9;
    private final PlayerEntity player;

    public ContainerHolding(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        this(windowId, playerInventory.field_70458_d, playerInventory, new InventoryHolding(extraData.func_150791_c()));
    }

    public ContainerHolding(int windowId, PlayerEntity player, PlayerInventory playerInventory, InventoryHolding inventoryHolding) {
        super((ContainerType)BloodMagicBlocks.HOLDING_CONTAINER.get(), windowId);
        this.player = player;
        this.inventoryHolding = inventoryHolding;
        int currentSlotHeldIn = player.field_71071_by.field_70461_c;
        this.setup(playerInventory, currentSlotHeldIn);
    }

    public void setup(PlayerInventory inventory, int currentSlotHeldIn) {
        for (int columnIndex = 0; columnIndex < 5; ++columnIndex) {
            this.func_75146_a(new SlotHolding(this, this.inventoryHolding, this.player, columnIndex, 8 + columnIndex * 36, 17));
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 41 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.func_75146_a(new SlotDisabled((IInventory)this.player.field_71071_by, actionBarIndex, 8 + actionBarIndex * 18, 99));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, actionBarIndex, 8 + actionBarIndex * 18, 99));
        }
    }

    public boolean func_75145_c(PlayerEntity entityPlayer) {
        return true;
    }

    public void func_75134_a(PlayerEntity entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.func_130014_f_().field_72995_K) {
            this.saveInventory(entityPlayer);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.func_130014_f_().field_72995_K) {
            this.saveInventory(this.player);
        }
    }

    public ItemStack func_82846_b(PlayerEntity entityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slotObject = (Slot)this.field_75151_b.get(slotIndex);
        int slots = this.field_75151_b.size();
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (stack.func_77973_b() instanceof ISigil ? (slotIndex < 5 ? !this.func_75135_a(stackInSlot, 5, slots, false) : !this.func_75135_a(stackInSlot, 0, 5, false)) : stack.func_77973_b() instanceof ItemSigilHolding && (slotIndex < 32 ? !this.func_75135_a(stackInSlot, 32, this.field_75151_b.size(), false) : !this.func_75135_a(stackInSlot, 5, 32, false))) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slotObject.func_75215_d(ItemStack.field_190927_a);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slotObject.func_190901_a(this.player, stackInSlot);
        }
        return stack;
    }

    public void saveInventory(PlayerEntity entityPlayer) {
        this.inventoryHolding.onGuiSaved(entityPlayer);
    }

    private class SlotHolding
    extends Slot {
        private final PlayerEntity player;
        private ContainerHolding containerHolding;

        public SlotHolding(ContainerHolding containerHolding2, IInventory inventory, PlayerEntity player, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.player = player;
            this.containerHolding = containerHolding2;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (EffectiveSide.get().isServer()) {
                this.containerHolding.saveInventory(this.player);
            }
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof ISigil && !(itemStack.func_77973_b() instanceof ItemSigilHolding);
        }
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(IInventory inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }
    }
}

