/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.arc;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.arc.IARCTool;
import wayoftime.bloodmagic.util.ChatUtil;

public class ItemARCToolBase
extends Item
implements IARCTool {
    private final double craftingMultiplier;
    private final double additionalOutputChance;

    public ItemARCToolBase(int maxDamage, double craftingMultiplier) {
        this(maxDamage, craftingMultiplier, 1.0);
    }

    public ItemARCToolBase(int maxDamage, double craftingMultiplier, double additionalOutputChance) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB).func_200918_c(maxDamage));
        this.craftingMultiplier = craftingMultiplier;
        this.additionalOutputChance = additionalOutputChance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.arctool.uses", new Object[]{stack.func_77958_k() - stack.func_77952_i()}).func_240699_a_(TextFormatting.GRAY));
        if (this.getCraftingSpeedMultiplier(stack) != 1.0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.arctool.craftspeed", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getCraftingSpeedMultiplier(stack))}).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.getAdditionalOutputChanceMultiplier(stack) != 1.0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.arctool.additionaldrops", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getAdditionalOutputChanceMultiplier(stack))}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public double getCraftingSpeedMultiplier(ItemStack stack) {
        return this.craftingMultiplier;
    }

    @Override
    public double getAdditionalOutputChanceMultiplier(ItemStack stack) {
        return this.additionalOutputChance;
    }
}

